/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.coupon;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.coupon.UmpayWriteOffReturnResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 解冻退回请求
 *
 * @author
 * @version UmpayWriteOffReturnRequest.java, v 0.1 2023-01-31 09:56:55
 */
@Data
public class UmpayWriteOffReturnRequest extends UmBizRequest<UmpayWriteOffReturnResponse> {

    private static final long serialVersionUID = -2213838555726479937L;

    /**
     * 服务商解冻退回单号,64个字符以内。可包含字母、数字、下划线;需保证在接入的服务商系统中不重复
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outReturnNo长度不能超过64")
    private String outReturnNo;

    /**
     * 服务商解冻单号writeoff_no和out_writeoff_no二选一必填，优先取writeoff_no；
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "outWriteoffNo长度不能超过64")
    private String outWriteoffNo;

    /**
     * 聚合收单平台解冻单号，在系统内唯一writeoff_no和out_writeoff_no二选一必填，优先取writeoff_no；
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "writeoffNo长度不能超过32")
    private String writeoffNo;

    @Override
    public Class<UmpayWriteOffReturnResponse> getResponseClass() {
        return UmpayWriteOffReturnResponse.class;
    }
}