/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.trade.pay;

import com.fshows.umpay.sdk.response.trade.pay.item.UmpayAlipayExtendParamsResponse;
import com.fshows.umpay.sdk.response.trade.pay.item.UmpayAlipayVoucherDetailResponse;
import com.fshows.umpay.sdk.response.trade.pay.item.UmpayFundBillResponse;
import com.fshows.umpay.sdk.response.trade.pay.item.UmpayRiskInfoResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author
 * @version UmpayScanCardResponse.java, v 0.1 2022-03-16 11:58:42
 */
@Data
public class UmpayScanCardResponse implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;


    /**
     * 聚合收单平台产生的订单号，在系统内唯一
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

    /**
     * 商户订单号,64 个字符以内、可包含字母、数字、下划线;需保证在接入的服务商系统中不重复
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 支付宝、微信订单号
     * <p>
     * (选填)
     */
    @Length(max = 64, message = "platformOrderNo长度不能超过64")
    private String platformOrderNo;

    /**
     * 订单状态0-支付中；1-支付成功；2-支付失败
     * <p>
     * (必填)
     */
    @NotNull
    private Integer payStatus;

    /**
     * 支付完成时间，支付成功时返回格式为yyyy-MM-ddHH:mm:ss，如2009年12月25日9点10分10秒表示为2009-12-2509:10:10
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "gmtClose长度不能超过32")
    private String gmtClose;

    /**
     * 订单总金额（单位元）
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal totalAmount;

    /**
     * 商家净收入计算公式：订单总金额 *（1-商户终端费率） + 交易补贴金
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal netMoney;

    /**
     * 买家实付金额（单位元）
     * <p>
     * (选填)
     */
    private BigDecimal buyerPayAmount;

    /**
     * 交易补贴金额，单位元，下游服务商给商户的交易补贴
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal subsidyFee;

    /**
     * 聚合收单平台手续费（单位元）
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal payPlatformFee;

    /**
     * 聚合收单平台手续费率
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal payPlatformRate;

    /**
     * 服务商手续费接入的服务商交易获得的返佣金额
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal liquidatorCommissionFee;

    /**
     * 服务商手续费率接入的服务商设置的手续费率
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal liquidatorCommissionRate;

    /**
     * 付款用户id，“微信openid”、“买家支付宝账户ID”等，当支付成功时返回
     * <p>
     * (选填)
     */
    @Length(max = 128, message = "userId长度不能超过128")
    private String userId;

    /**
     * 支付平台：1-支付宝；2-微信；6-云闪付
     * <p>
     * (必填)
     */
    @NotNull
    private Integer payPlatformType;

    /**
     * 订单类型，支付成功时返回：1-条码支付；
     * <p>
     * (特殊必填)
     */
    private Integer orderType;

    /**
     * 本次交易支付所使用的单品券优惠信息
     * <p>
     * (特殊必填)
     */
    @Length(max = 1024, message = "discountGoodsDetail长度不能超过1024")
    private String discountGoodsDetail;

    /**
     * 支付宝业务拓展参数--花呗分期
     * <p>
     * (特殊必填)
     */
    private UmpayAlipayExtendParamsResponse alipayExtendParams;

    /**
     * 付款银行，采用字符串类型的银行标识，微信交易时有返回，具体请查看&lt;微信官方文档&gt;
     * <p>
     * (选填)
     */
    @Length(max = 16, message = "bankType长度不能超过16")
    private String bankType;

    /**
     * 应结订单金额（微信支付宝）
     * <p>
     * (选填)
     */
    private BigDecimal receiptAmount;

    /**
     * 交易支付使用的资金渠道，支付宝交易时有返回,具体请查看&lt;支付宝官方文档&gt;
     * <p>
     * (选填)
     */
    private List<UmpayFundBillResponse> fundBillList;

    /**
     * 代金券金额
     * <p>
     * (选填)
     */
    private BigDecimal couponFee;

    /**
     * 支付宝本交易支付时使用的所有优惠券信息详见&lt;支付宝官方文档&gt;
     * <p>
     * (特殊必填)
     */
    private List<UmpayAlipayVoucherDetailResponse> alipayVoucherDetailList;

    /**
     * 平台优惠金额 （支付宝）
     * <p>
     * (选填)
     */
    private BigDecimal discountAmount;

    /**
     * 商家优惠金额 （支付宝）
     * <p>
     * (选填)
     */
    private BigDecimal mdiscountAmount;

    /**
     * 最大分账金额
     * <p>
     * (选填)
     */
    private BigDecimal maxShareAmount;

    /**
     * 风险控制信息
     * <p>
     * (选填)
     */
    private UmpayRiskInfoResponse riskInfo;
    /**
     * 通道商户号微信、支付宝、云闪付的商户商编
     * <p>
     * (特殊必填)
     */
    private String subMerchantNo;

    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     * <p>
     * (必填)
     */
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在服务商系统中唯一
     * <p>
     * (必填)
     */
    private String merchantId;
    /**
     * 1:支付宝线下支付,  3:微信线下支付, 16:银行卡收单借记, 17:银行卡收单贷记, 20:银联线下支付,  232:微信0费率行业, 233:微信0.1费率行业, 234:微信0.3费率行业, 235:微信0.38费率行业, 236:微信0.6费率行业, 300:支付宝0费率行业, 301:支付宝0.1费率行业，241:普通支付宝预授权，242:普通微信预授权，243:普通银联二维码预授权，244:普通支付宝预授权完成，245:普通微信预授权完成，246:普通银联二维码预授权完成
     * 注：银行卡和银联二维码等区分借贷记的交易类型，仅在订单状态为1-支付成功才为准确类型。其他订单状态下该参数不准确
     */
    private String payType;

}