package com.fshows.umpay.sdk.response.machine;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author huanghai
 * @version 1.0 UmpayMachineBindOrUnBindResponse
 * @date 2022/4/12 14:27
 */
@Data
public class UmpayMachineBindOrUnBindResponse implements Serializable {
    private static final long serialVersionUID = -6966180314937694599L;

    /**
     * 结果值
     */
    private String result;

    /**
     * 失败原因
     */
    @JSONField(name = "fail_reason")
    private String failReason;

    /**
     *子商户号，当一个商户存在多个子商户号时必填；
     */
    @JSONField(name = "sub_mch_id")
    private String subMchId;

    /**
     *支付平台：1-支付宝；2-微信；8-银行卡刷卡；默认8-银行卡刷卡；
     */
    @JSONField(name = "pay_platform_type")
    private String payPlatformType;

    /**
     *设备类型
     * 取值范围：
     * 取值 取值说明
     * 02 传统POS
     * 03 mPOS
     * 04 智能POS
     * 08 手机POS
     * 10 条码支付受理终端
     * 11  辅助终端
     * 默认：10 条码支付受理终端；
     */
    @JSONField(name = "terminal_type")
    private String terminalType;

    /**
     *终端设备号；
     * 当bind_type=1-pos终端解绑时，
     * terminal_id和（prov_id、model_id、sn_number）二选一必填；
     */
    @JSONField(name = "terminal_id")
    private String terminalId;

    /**
     *受理终端布放地址的纬度
     * 如服务商未上送纬度，则由业务系统根据装机地址生成经纬度信息
     */
    @JSONField(name = "terminal_gps_lat")
    private String terminalGpsLat;

    /**
     * 受理终端布放地址的经度
     * 如服务商未上送经度，则由业务系统根据装机地址生成经纬度信息
     */
    @JSONField(name = "terminal_gps_long")
    private String terminalGpsLong;

    /**
     * 终端机具状态
     * 1-绑定中；2-绑定成功；3-绑定失败；4-解绑中；5-解绑成功；6-解绑失败
     */
    @JSONField(name = "terminal_status")
    private String terminalStatus;
}
