/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.request.merchant.item;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 商户费率
 *
 * @author liluqing
 * @version UmpayMerchantRateRequest.java, v 0.1 2022-03-16 15:32
 */
@Data
public class UmpayMerchantRateRequest implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;

    /**
     * 费率类型1-支付宝线下支付；3-微信线下支付；14-pos刷卡（借记 1000元以下）；15-pos刷卡（贷记 1000元以下）；16-pos刷卡（借记 1000元以上）；17-pos刷卡（贷记 1000元以上）20-银联云闪付（1000元以下）300-支付宝0费率；301-支付宝0.1%费率；302-微信0费率；303-微信0.1%费率；304-微信0.3%费率；305-微信0.38%费率；306-微信0.6%费率；30-数字人民币
     * <p>
     * (特殊必填)
     */
    private BigDecimal payType;

    /**
     * 商户终端费率
     * <p>
     * (特殊必填)
     */
    private BigDecimal merchantRate;

    /**
     * pos交易借记封顶，单位：元；
     * <p>
     * (特殊必填)
     */
    private BigDecimal merchantPosLimit;
}