/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.fund;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.fund.UmpayDrawApplyOpenResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 提现权限开通
 *
 * @author
 * @version UmpayDrawApplyOpenRequest.java, v 0.1 2022-03-16 16:34:54
 */
@Data
public class UmpayDrawApplyOpenRequest extends UmBizRequest<UmpayDrawApplyOpenResponse> {

    private static final long serialVersionUID = -2213838555942698562L;


    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻成功后由平台返回
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 开通的提现类型：0-D0提现；1-D1提现示例：1
     *
     * (必填)
     */
    @NotNull
    private Integer drawType;

    @Override
    public Class<UmpayDrawApplyOpenResponse> getResponseClass() {
        return UmpayDrawApplyOpenResponse.class;
    }
}