/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.fund.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 结算结果查询
 *
 * @author linzy
 * @version UmpaySettlementQueryQueryResponse.java, v 0.1 2022-03-16 16:33:25 linzy
 */
@Data
public class UmpaySettlementQueryResponse implements Serializable {

    private static final long serialVersionUID = 3830708515126914828L;

    /**
     * 聚合收单平台为商户分配的唯一ID
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "storeId长度不能超过32")
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在服务商系统中唯一
     * <p>
     * (特殊必填)
     */
    @Length(max = 20, message = "merchantId长度不能超过20")
    private String merchantId;

    /**
     * （2-D1结算 3-D1补款 4-D1差异退款补打5-T1结算 6-T1结算补打 7-T1差异补打 ）
     * <p>
     * (必填)
     */
    @NotNull
    private Integer settleType;

    /**
     * 提现状态 0：交易中,1:交易成功,2:交易失败
     * <p>
     * (必填)
     */
    @NotNull
    private Integer transferStatus;

    /**
     * 结算金额
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal amount;

    /**
     * 账户类型：1-对公；0-对私
     * <p>
     * (必填)
     */
    @NotNull
    private Integer isPublicAccount;

    /**
     * 结算账户户名
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 16, message = "bankCardName长度不能超过16")
    private String bankCardName;

    /**
     * 银行卡号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "bankCard长度不能超过32")
    private String bankCard;

    /**
     * 开户支行名称
     * <p>
     * (选填)
     */
    @Length(max = 64, message = "bankName长度不能超过64")
    private String bankName;

    /**
     * 创建时间
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "createTime长度不能超过32")
    private String createTime;

    /**
     * 更新时间
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "updateTime长度不能超过32")
    private String updateTime;

    /**
     * 交易发生的日期；
     * <p>
     * (选填)
     */
    @Length(max = 16, message = "payDay长度不能超过16")
    private String payDay;

    /**
     * 失败原因
     * <p>
     * (选填)
     */
    @Length(max = 256, message = "failReason长度不能超过256")
    private String failReason;

    /**
     * 返回聚合收单平台的结算单号；
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "settleNo长度不能超过64")
    private String settleNo;

    /**
     * 返回聚合收单平台的打款流水号；如果发生补打时，结算单号相同，该流水号不一致
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "orderSn长度不能超过64")
    private String orderSn;

    /**
     * 大小额联行号
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "bankNo长度不能超过32")
    private String bankNo;

}