/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.request.trade.pay.item;

import lombok.Data;

import java.io.Serializable;

/**
 * 支付宝业务拓展参数--花呗分期
 *
 * @author liluqing
 * @version UmpayAlipayExtendParamsRequest.java, v 0.1 2022-03-16 11:52
 */
@Data
public class UmpayAlipayExtendParamsRequest implements Serializable {

    private static final long serialVersionUID = 2714839216129421792L;

    /**
     * 花呗分期期数，仅支持传入3、6、12，分别代表分期期数示例：3
     * <p>
     * (选填)
     */
    private Integer hbFqNum;

    /**
     * 花呗分期手续费承担模式0=消费者承担；100=商户承担（间联通道暂不支持商户承担）示例：0
     * <p>
     * (选填)
     */
    private Integer hbFqSellerPercent;
    /**
     * 系统商编号该参数作为系统商返佣依据，请填写系统商签约协议PID
     */
    private String sysServiceProviderId;
    /**
     * 点餐场景码
     */
    private String foodOrderType;
    /**
     * 行业数据回流信息
     */
    private String industryRefluxInfo;
    /**
     * 卡类型
     */
    private String cardType;

    /**
    * 信用卡分期数
    */
    private String fqNum;

    /**
    *分期手续费商家承担比例
    */
    private String fqSellerPercent;

    /**
    * 分期渠道
     * 示例值：alipayfq_cc
    */
    private String fqChannels;
}