/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.AggregationMerchantEnterResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * @author youmingming
 * @version AggregationMerchantEnterRequest.java, v 0.1 2022-02-09 下午5:17 youmingming
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AggregationMerchantModifyRequest extends UmBizRequest<AggregationMerchantEnterResponse> {

    private static final long serialVersionUID = -2213838555575424675L;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在系统中唯一
     */
    @JSONField(name = "merchant_id")
    private String merchantId;

    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     */
    @JSONField(name = "store_id")
    private String storeId;

    /**
     * 商户类型：1-小微；2-个体户；3企事业
     * 商户审核已通过，该参数不允许变更；
     */
    @JSONField(name = "merchant_type")
    private Integer merchantType;

    /**
     * 商户全称
     * 若商户类型为1-小微商户，商户名称应填“商户_XXX”（XXX为小微商户身份证上的姓名）
     * 示例：商户_张三
     * 若商户类型为2-个体户及3-企事业，商户名称应填写商户营业执照上的名称
     * 示例：张三的水果店
     * 个体工商户营业执照没有商家名称或者名称为“*”或者“***”，则商户名称应填 “个体户XXX”（XXX为营业执照上经营者姓名）
     * 示例：个体户张三
     * <p>
     * 商户审核已通过，该参数不允许变更；
     */
    @JSONField(name = "merchant_name")
    private String merchantName;

    /**
     * 商户简称,在支付宝、微信支付时展示给消费者
     */
    @JSONField(name = "alias_name")
    private String aliasName;

    /**
     * 客服电话
     */
    @JSONField(name = "service_phone")
    private String servicePhone;

    /**
     * 经营类目，MCC商户行业编码；数据字典请联系我方运营人员
     */
    @JSONField(name = "category_id")
    private String categoryId;

    /**
     * 商户邮箱地址
     */
    private String email;

    /**
     * 商户座机号码
     */
    private String phone;

    /**
     * 商户手机号码
     */
    private String mobile;

    /**
     * 省级编码
     */
    @JSONField(name = "province_code")
    private String provinceCode;

    /**
     * 市级编码
     */
    @JSONField(name = "city_code")
    private String cityCode;

    /**
     * 区级编码
     */
    @JSONField(name = "district_code")
    private String districtCode;

    /**
     * 商户经营详细地址
     */
    @JSONField(name = "store_address")
    private String storeAddress;

    /**
     * 商户门头照
     */
    @JSONField(name = "store_front_img")
    private String storeFrontImg;

    /**
     * 收银台照片
     */
    @JSONField(name = "checkstand_pic")
    private String checkstandPic;

    /**
     * 店内环境照
     */
    @JSONField(name = "indoor_pic")
    private String indoorPic;

    /**
     * 商户营业时间
     */
    @JSONField(name = "business_time")
    private String businessTime;

    /**
     * 商户地址经度
     */
    private String longitude;

    /**
     * 商户地址维度
     */
    private String latitude;

    /**
     * 商户经营执照证件类型:
     * NATIONAL_LEGAL（营业执照）；NATIONAL_LEGAL_MERGE（营业执照多证合一）;INST_RGST_CTF：事业单位法人证书；
     * 示例：NATIONAL_LEGAL
     * 商户审核已通过，该参数不允许变更；
     */
    @JSONField(name = "business_license_type")
    private String businessLicenseType;

    /**
     * 营业执照注册号
     * 商户审核已通过，该参数不允许变更；
     */
    @JSONField(name = "business_license")
    private String businessLicense;

    /**
     * 营业执照照片，传<图片批量上传>返回的对应file_id
     */
    @JSONField(name = "business_license_img")
    private String businessLicenseImg;

    /**
     * 营业执照有效期限，格式为：yyyy-MM-dd-yyyy-MM-dd
     * (商户类型为2-个体户或者3-企事业时必填)
     */
    @JSONField(name = "business_expiry")
    private String businessExpiry;

    /**
     * 法人姓名
     * 商户审核已通过，该参数不允许变更；
     */
    @JSONField(name = "id_card_name")
    private String idCardName;

    /**
     * 法人身份证号码
     * 商户审核已通过，该参数不允许变更；
     */
    @JSONField(name = "id_card_num")
    private String idCardNum;

    /**
     * 法定代表人证件类型：
     * 01 身份证
     * 03 护照
     * 04 香港居民来往内地通行证（回乡证）
     * 05 台湾同胞来往内地通行证（台胞证）
     * 09 临时身份证
     * 10 外国人居留证
     * 11 澳门居民来往内地通行证（回乡证）
     * 若不填，默认为01
     * 12港澳居民证 ，13台湾居民证
     */
    @JSONField(name = "id_card_type")
    private String idCardType;

    /**
     * 手持身份证照片
     */
    @JSONField(name = "id_card_hand_img")
    private String idCardHandImg;

    /**
     * 法人身份证正面照片
     */
    @JSONField(name = "id_card_heads_pic")
    private String idCardHeadsPic;

    /**
     * 法人身份证反面照片
     */
    @JSONField(name = "id_card_tails_pic")
    private String idCardTailsPic;

    /**
     * 法人身份证证件有效期，格式为：yyyy-MM-dd-yyyy-MM-dd
     */
    @JSONField(name = "id_card_expiry")
    private String idCardExpiry;

    /**
     * 结算卡类型：0-非法人；1-法人；2-企业
     */
    @JSONField(name = "card_type")
    private Integer cardType;

    /**
     * 账户类型：1-对公；0-对私
     */
    @JSONField(name = "is_public_account")
    private Integer isPublicAccount;

    /**
     * 结算银行卡开户名
     * 商户是法人对私结算时，该字段应与法人姓名一致；
     * 商户是企业对公结算时，该字段应与营业执照名称一致
     */
    @JSONField(name = "bank_card_name")
    private String bankCardName;

    /**
     * 结算人身份证号
     * （结算卡类型为0-非法人结算时必填）
     */
    @JSONField(name = "bank_id_card_num")
    private String bankIdCardNum;

    /**
     * 结算人证件类型
     * 01 身份证
     * 03 护照
     * 04 香港居民来往内地通行证（回乡证）
     * 05 台湾同胞来往内地通行证（台胞证）
     * 09 临时身份证
     * 10 外国人居留证
     * 11 澳门居民来往内地通行证（回乡证）
     * （账户类型为对公时不填写）
     * 12港澳居民证 ，13台湾居民证
     */
    @JSONField(name = "bank_id_card_type")
    private String bankIdCardType;

    /**
     * 非法人清算授权函，传<图片批量上传>返回的对应file_id
     * （结算卡类型为0-非法人结算时必填）
     */
    @JSONField(name = "author_certificate_pic")
    private String authorCertificatePic;

    /**
     * 结算银行卡卡号
     */
    @JSONField(name = "bank_card_no")
    private String bankCardNo;

    /**
     * 结算银行卡正面照，传<图片批量上传>返回的对应file_id
     * （账户类型为0-对私时必填)
     */
    @JSONField(name = "bank_card_pic")
    private String bankCardPic;

    /**
     * 结算卡开户支行
     */
    @JSONField(name = "open_bank")
    private String openBank;

    /**
     * 开户支行联行号
     * （账户类型为1-对公时必填；open_union_pay=1-签约时必填）
     */
    @JSONField(name = "united_bank_no")
    private String unitedBankNo;

    /**
     * 银行开户许可证，传<图片批量上传>返回的对应file_id
     * (账户类型为1-对公时必填)
     */
    @JSONField(name = "bank_account_opening_certificate")
    private String bankAccountOpeningCertificate;

    /**
     * 结算人身份证正面照，传<图片批量上传>返回的对应file_id
     * （结算卡类型为0-非法人结算时必填）
     */
    @JSONField(name = "settle_id_card_heads_pic")
    private String settleIdCardHeadsPic;

    /**
     * 结算人身份证反面照，传<图片批量上传>返回的对应file_id
     * （结算卡类型为0-非法人结算时必填）
     */
    @JSONField(name = "settle_id_card_tails_pic")
    private String settleIdCardTailsPic;

    /**
     * 结算人身份证证件有效期限，格式为：yyyy-MM-dd-yyyy-MM-dd
     * （结算卡类型为0-非法人结算时必填）
     */
    @JSONField(name = "settle_id_card_expiry")
    private String settleIdCardExpiry;

    /**
     * 银联商户经营名称
     * 签约银联云闪付时必填
     */
    @JSONField(name = "union_alias_name")
    private String unionAliasName;

    /**
     * 功能开通：1-开通pos功能；
     */
    @JSONField(name = "open_permissions")
    private String openPermissions;

    /**
     * 商户特殊行业资质证明，医药、教育行业需上传
     * 传<图片批量上传>返回的对应file_id
     */
    @JSONField(name = "industry_qualification_img")
    private String industryQualificationImg;

    /**
     * 其他证明
     * 传<图片批量上传>返回的对应file_id
     */
    @JSONField(name = "else_img")
    private String elseImg;

    /**
     * 默认为空，传1则需要补充微信实名认证信息
     */
    @JSONField(name = "wx_auth_api")
    private Integer wxAuthApi;

    /**
     * 联系人姓名，用于微信实名认证扫码，若与法人id_card_name一致，则无需填写
     */
    @JSONField(name = "wx_id_card_name")
    private String wxIdCardName;

    /**
     * 联系人手机号，用于微信实名认证若与入驻接口mobile一致，则无需填写
     */
    @JSONField(name = "wx_auth_mobile")
    private String wxAuthMobile;

    /**
     * 联系人身份证号码，若与入驻接口id_card_num一致，则无需填写
     */
    @JSONField(name = "wx_id_card_num")
    private String wxIdCardNum;

    /**
     * 营业执照注册地址，若与store_address一致，则无需填写
     */
    @JSONField(name = "company_address")
    private String companyAddress;

    /**
     * 主体类型为事业单位或其他组织时，登记证书信息必填。
     * 证书类型：
     * CERTIFICATE_TYPE_2388：事业单位法人证书
     * CERTIFICATE_TYPE_2389：统一社会信用代码证书
     * CERTIFICATE_TYPE_2390：有偿服务许可证（军队医院适用）
     * CERTIFICATE_TYPE_2391：医疗机构执业许可证（军队医院适用）
     * CERTIFICATE_TYPE_2392：企业营业执照（挂靠企业的党组织适用）
     * CERTIFICATE_TYPE_2393：组织机构代码证（政府机关适用）
     * CERTIFICATE_TYPE_2394：社会团体法人登记证书
     * CERTIFICATE_TYPE_2395：民办非企业单位登记证书
     * CERTIFICATE_TYPE_2396：基金会法人登记证书
     * CERTIFICATE_TYPE_2397：慈善组织公开募捐资格证书
     * CERTIFICATE_TYPE_2398：农民专业合作社法人营业执照
     * CERTIFICATE_TYPE_2399：宗教活动场所登记证
     * CERTIFICATE_TYPE_2400：其他证书/批文/证明
     * 主体类型为事业单位或其他组织时，登记证书信息必填。
     */
    @JSONField(name = "cert_type")
    private String certType;

    /**
     * 单位证明函照片，主体类型为事业单位时必填（
     * 传<图片批量上传>返回的对应file_id）
     */
    @JSONField(name = "company_prove_copy")
    private String companyProveCopy;

    /**
     * 小微经营类型：
     * MICRO_TYPE_STORE：门店场所
     * MICRO_TYPE_MOBILE：流动经营/便民服务
     * MICRO_TYPE_ONLINE：线上商品/服务交易
     * 主体类型为小微商户时必填
     */
    @JSONField(name = "micro_biz_type")
    private String microBizType;

    /**
     * 行业经营许可证资质照片，最多上传6张资质照片（传<图片批量上传>返回的对应file_id，多个用","分隔）
     */
    @JSONField(name = "operation_copy_list")
    private String operationCopyList;

    /**
     * 1、民办中小学及幼儿园；2、民办大学及学院当入驻接口选择其他教育机构（8299）时，此处可以补充子类目
     */
    @JSONField(name = "wx_special_operation")
    private String wxSpecialOperation;

    /**
     * 预付卡权限开通：0-不开通；1-开通
     */
    @JSONField(name = "prepay_permissions")
    private Integer prepayPermissions;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class getResponseClass() {
        return AggregationMerchantEnterResponse.class;
    }
}