/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.trade.pay;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author
 * @version UmpayGetWxFaceAuthInfoResponse.java, v 0.1 2022-03-16 13:59:00
 */
@Data
public class UmpayGetWxFaceAuthInfoResponse implements Serializable {

    private static final long serialVersionUID = -2213838555531762051L;


    /**
     * 返回状态码,此字段是通信标识SUCCES/FAIL
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 16, message = "returnCode长度不能超过16")
    private String returnCode;

    /**
     * 返回信息，如果非空则为错误原因Eg:签名参数格式误
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "returnMsg长度不能超过128")
    private String returnMsg;

    /**
     * SDK调用凭证,用于调用SDK的人脸识别接口
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 4096, message = "authinfo长度不能超过4096")
    private String authinfo;

    /**
     * authinfo的有效时间, 单位秒。 例如: 3600在有效时间内, 对于同一台终端设备，相同的参数的前提下(如：相同的公众号、商户号、 门店编号等），可以用同一个authinfo，多次调用SDK的getWxpayfaceCode接口。
     * <p>
     * (必填)
     */
    @NotNull
    private Integer expiresIn;

    /**
     * 随机字符串Eg:3f30ab209c874345936d162433bd3601
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "nonceStr长度不能超过32")
    private String nonceStr;

    /**
     * 子商户公众账号ID
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

    /**
     * 微信支付分配的子商户号。微信签约接口入驻成功时返回
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

}