/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.trade.order;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version UmpayOrderCloseResponse.java, v 0.1 2022-03-16 14:14:12
 */
@Data
public class UmpayOrderCloseResponse implements Serializable {

    private static final long serialVersionUID = -2213838555340997716L;


    /**
     * 服务商的订单号,64个字符以内。可包含字母、数字、下划线;需保证在接入的服务商系统中唯一
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outTradeNo长度不能超过64")
    private String outTradeNo;

    /**
     * 聚合收单平台订单号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

}