/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.response.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 终端信息
 *
 * @author liluqing
 * @version MerchantTerminalDetail.java, v 0.1 2022-03-16 17:03
 */
@Data
public class MerchantTerminalDetailResponse implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;

    /**
     * 平台类型：1-支付宝；2-微信；
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "payPlatformType长度不能超过1")
    private String payPlatformType;

    /**
     * 终端设备号，聚合平台的唯一编号
     * <p>
     * (选填)
     */
    @Length(max = 8, message = "terminalId长度不能超过8")
    private String terminalId;

    /**
     * 辅助终端是否绑定成功：1-绑定成功，2-绑定失败；
     * <p>
     * (选填)
     */
    private Integer terminalStatus;

    /**
     * 辅助终端绑定失败原因
     * <p>
     * (选填)
     */
    @Length(max = 128, message = "terminalMsg长度不能超过128")
    private String terminalMsg;

    /**
     * 受理终端布放地址的纬度如服务商未上送纬度，则由业务系统根据终端布放地址生成经纬度信息
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "terminalGpsLat长度不能超过32")
    private String terminalGpsLat;

    /**
     * 受理终端布放地址的经度如服务商未上送经度，则由业务系统根据终端布放地址生成经纬度信息
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "terminalGpsLong长度不能超过32")
    private String terminalGpsLong;
}