/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.merchant;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author
 * @version UmpaySubmerchantRateQueryResponse.java, v 0.1 2022-03-16 15:28:37
 */
@Data
public class UmpaySubmerchantRateQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555763606045L;


    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     * <p>
     * (必填)
     */
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在服务商系统中唯一
     * <p>
     * (必填)
     */
    private String externalId;

    /**
     * 商户终端费率，精确到小数点后5位
     * <p>
     * (必填)
     */
    private BigDecimal merchantRate;

    /**
     * 平台类型1-支付宝线下支付；3-微信线下支付；20-云闪付支付
     * <p>
     * (必填)
     */
    private Integer payType;

}