/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.merchant;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 商户信息查询响应结果
 *
 * @author
 * @version AggregationMerchantQueryResponse.java, v 0.1 2022-03-16 15:08:39
 */
@Data
public class AggregationMerchantQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555398757341L;


    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在服务商系统中唯一
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "merchantId长度不能超过20")
    private String merchantId;

    /**
     * 商户状态0-关闭；1-开启；2-未通过审核/未通过审核，待补充资料；3-审核中
     * <p>
     * (特殊必填)
     */
    private Integer status;

    /**
     * 商户审核状态：1、未审核 2、审核通过 3、审核不通过（商户入驻及商户修改最新审核状态）
     * <p>
     * (特殊必填)
     */
    private String verifyStatus;

    /**
     * 原因
     * <p>
     * (特殊必填)
     */
    @Length(max = 255, message = "msg长度不能超过255")
    private String msg;

    /**
     * 商户类型：1-小微；2-个体户；3企事业
     * <p>
     * (特殊必填)
     */
    private Integer merchantType;

    /**
     * 商户全称
     * <p>
     * (特殊必填)
     */
    @Length(max = 255, message = "merchantName长度不能超过255")
    private String merchantName;

    /**
     * 商户简称,在支付宝、微信支付时展示给消费者
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "aliasName长度不能超过64")
    private String aliasName;

    /**
     * 客服电话
     * <p>
     * (特殊必填)
     */
    @Length(max = 16, message = "servicePhone长度不能超过16")
    private String servicePhone;

    /**
     * 经营类目，MCC商户行业编码
     * <p>
     * (特殊必填)
     */
    @Length(max = 128, message = "categoryId长度不能超过128")
    private String categoryId;

    /**
     * 商户邮箱地址
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "email长度不能超过32")
    private String email;

    /**
     * 商户手机号码
     * <p>
     * (特殊必填)
     */
    @Length(max = 16, message = "mobile长度不能超过16")
    private String mobile;

    /**
     * 省级编码
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "provinceCode长度不能超过32")
    private String provinceCode;

    /**
     * 市级编码
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "cityCode长度不能超过32")
    private String cityCode;

    /**
     * 区级编码
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "districtCode长度不能超过32")
    private String districtCode;

    /**
     * 商户经营详细地址
     * <p>
     * (特殊必填)
     */
    @Length(max = 255, message = "storeAddress长度不能超过255")
    private String storeAddress;

    /**
     * 营业执照注册号
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "businessLicense长度不能超过32")
    private String businessLicense;

    /**
     * 营业执照有效期限，格式为：yyyy-MM-dd-yyyy-MM-dd
     * <p>
     * (特殊必填)
     */
    @Length(max = 128, message = "businessExpiry长度不能超过128")
    private String businessExpiry;

    /**
     * 法人姓名
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "idCardName长度不能超过32")
    private String idCardName;

    /**
     * 法人身份证号码
     * <p>
     * (特殊必填)
     */
    @Length(max = 18, message = "idCardNum长度不能超过18")
    private String idCardNum;

    /**
     * 法人身份证证件有效期，格式为：yyyy-MM-dd-yyyy-MM-dd
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "idCardExpiry长度不能超过64")
    private String idCardExpiry;

    /**
     * 结算卡类型：0-非法人；1-法人；2-企业
     * <p>
     * (特殊必填)
     */
    private Integer cardType;

    /**
     * 账户类型：1-对公；0-对私
     * <p>
     * (特殊必填)
     */
    private Integer isPublicAccount;

    /**
     * 结算银行卡开户名
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "bankCardName长度不能超过64")
    private String bankCardName;

    /**
     * 结算人身份证号
     * <p>
     * (特殊必填)
     */
    @Length(max = 18, message = "bankIdCardNum长度不能超过18")
    private String bankIdCardNum;

    /**
     * 结算银行卡卡号
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "bankCardNo长度不能超过32")
    private String bankCardNo;

    /**
     * 结算卡开户支行
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "openBank长度不能超过64")
    private String openBank;

    /**
     * 开户支行联行号
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "unitedBankNo长度不能超过64")
    private String unitedBankNo;

    /**
     * 结算人身份证证件有效期限，格式为：yyyy-MM-dd-yyyy-MM-dd
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "settleIdCardExpiry长度不能超过64")
    private String settleIdCardExpiry;

    /**
     * 结算类型：0-D1自动结算；1-D0提现；3-D1提现；5-T1自动结算；
     * <p>
     * (特殊必填)
     */
    private Integer settleType;

    /**
     * 分账商户类型0-普通商户未开通分账功能；1-分账商户；2-分账接收方
     * <p>
     * (特殊必填)
     */
    private Integer ledgerType;

    /**
     * pos权限0-未开通；1-已开通
     * <p>
     * (特殊必填)
     */
    private Integer isOpenPos;

    /**
     * 默认为空，传1则需要补充微信实名认证信息
     * <p>
     * (选填)
     */
    private Integer wxAuthApi;

    /**
     * 联系人姓名，用于微信实名认证扫码，若与法人id_card_name一致，则无需填写
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "wxIdCardName长度不能超过32")
    private String wxIdCardName;

    /**
     * 联系人手机号，用于微信实名认证若与入驻接口mobile一致，则无需填写
     * <p>
     * (选填)
     */
    @Length(max = 16, message = "wxAuthMobile长度不能超过16")
    private String wxAuthMobile;

    /**
     * 联系人身份证号码，若与入驻接口id_card_num一致，则无需填写
     * <p>
     * (选填)
     */
    @Length(max = 18, message = "wxIdCardNum长度不能超过18")
    private String wxIdCardNum;

    /**
     * 营业执照注册地址，若与store_address一致，则无需填写
     * <p>
     * (选填)
     */
    @Length(max = 18, message = "companyAddress长度不能超过18")
    private String companyAddress;

    /**
     * 主体类型为事业单位或其他组织时，登记证书信息必填。证书类型：CERTIFICATE_TYPE_2388：事业单位法人证书CERTIFICATE_TYPE_2389：统一社会信用代码证书CERTIFICATE_TYPE_2390：有偿服务许可证（军队医院适用）CERTIFICATE_TYPE_2391：医疗机构执业许可证（军队医院适用）CERTIFICATE_TYPE_2392：企业营业执照（挂靠企业的党组织适用）CERTIFICATE_TYPE_2393：组织机构代码证（政府机关适用）CERTIFICATE_TYPE_2394：社会团体法人登记证书CERTIFICATE_TYPE_2395：民办非企业单位登记证书CERTIFICATE_TYPE_2396：基金会法人登记证书CERTIFICATE_TYPE_2397：慈善组织公开募捐资格证书CERTIFICATE_TYPE_2398：农民专业合作社法人营业执照CERTIFICATE_TYPE_2399：宗教活动场所登记证CERTIFICATE_TYPE_2400：其他证书/批文/证明主体类型为事业单位或其他组织时，登记证书信息必填。
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "certType长度不能超过32")
    private String certType;

    /**
     * 单位证明函照片，主体类型为事业单位时必填（传&lt;图片批量上传&gt;返回的对应file_id）
     * <p>
     * (特殊必填)
     */
    private String companyProveCopy;

    /**
     * 小微经营类型：MICRO_TYPE_STORE：门店场所MICRO_TYPE_MOBILE：流动经营/便民服务MICRO_TYPE_ONLINE：线上商品/服务交易主体类型为小微商户时必填
     * <p>
     * (特殊必填)
     */
    @Length(max = 18, message = "microBizType长度不能超过18")
    private String microBizType;

    /**
     * 行业经营许可证资质照片，最多上传6张资质照片（传<图片批量上传>返回的对应file_id，多个用","分隔）
     */
    private String operationCopyList;

    /**
     * 1、民办中小学及幼儿园；2、民办大学及学院当入驻接口选择其他教育机构（8299）时，此处可以补充子类目
     * <p>
     * (选填)
     */
    private Integer wxSpecialOperation;

}