/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.activity;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 微信活动报名接口
 *
 * @author
 * @version UmpayWxActivityApplyResponse.java, v 0.1 2022-03-16 16:52:15
 */
@Data
public class UmpayWxActivityApplyResponse implements Serializable {

    private static final long serialVersionUID = -2213838555835000341L;


    /**
     * 申请单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "applicationId长度不能超过32")
    private String applicationId;

}