/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.picture;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author youmingming
 * @version FilesUploadDirectRequest.java, v 0.1 2022-03-09 2:36 PM youmingming
 */
@Data
public class FilesUploadDirectRequest implements Serializable {

    private static final long serialVersionUID = 1425723014552214264L;

    /**
     * 图片地址
     */
    @NotBlank(message = "图片链接不能为空")
    private String pictureUrl;
    /**
     * 应用id
     */
    private String appId;

    /**
     * 上传地址
     */
    private String uploadUrl;

    /**
     * 付呗密钥
     */
    private String fbPrivateKey;

    /**
     * 超时时间
     */
    private Integer timeout;

    @Override
    public String toString() {
        return "FilesUploadDirectRequest{" +
                "pictureUrl='" + pictureUrl + '\'' +
                ", appId='" + appId + '\'' +
                ", uploadUrl='" + uploadUrl + '\'' +
                ", timeout=" + timeout +
                '}';
    }
}