/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.picture;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.request.picture.item.FileInfoItemRequest;
import com.fshows.umpay.sdk.response.picture.AggregationFilesUploadDirectResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;


/**
 * @author youmingming
 * @version AggregationFilesUploadDirectRequest.java, v 0.1 2022-02-10 上午9:40 youmingming
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AggregationFilesUploadDirectRequest extends UmBizRequest<AggregationFilesUploadDirectResponse> {
    private static final long serialVersionUID = -1907334069735528484L;

    /**
     * 待上传文件URL列表,图片格式包括png、jpg、gif
     */
    @JSONField(name = "file_list")
    private List<FileInfoItemRequest> fileList;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<AggregationFilesUploadDirectResponse> getResponseClass() {
        return AggregationFilesUploadDirectResponse.class;
    }
}