/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.UmpaySubmerchantRateQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * 查询商户终端费率
 *
 * @author
 * @version UmpaySubmerchantRateQueryRequest.java, v 0.1 2022-03-16 15:28:37
 */
@Data
public class UmpaySubmerchantRateQueryRequest extends UmBizRequest<UmpaySubmerchantRateQueryResponse> {

    private static final long serialVersionUID = -2213838555110690022L;


    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回，external_id和store_id二选一必填
     * <p>
     * (特殊必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在服务商系统中唯一，external_id和store_id二选一必填
     * <p>
     * (特殊必填)
     */
    @Length(max = 20, message = "externalId长度不能超过20")
    private String externalId;

    /**
     * 平台类型1-支付宝线下支付；3-微信线下支付；20-云闪付支付（1000元以下）；30-数字人民币
     * <p>
     * (必填)
     */
    @NotNull
    private Integer payType;

    @Override
    public Class<UmpaySubmerchantRateQueryResponse> getResponseClass() {
        return UmpaySubmerchantRateQueryResponse.class;
    }
}