/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.fund;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.fund.UmpayTradeBillDownloadResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 对账单下载请求参数
 *
 * @author
 * @version UmpayTradeBillDownloadRequest.java, v 0.1 2022-03-16 14:48:41
 */
@Data
public class UmpayTradeBillDownloadRequest extends UmBizRequest<UmpayTradeBillDownloadResponse> {

    private static final long serialVersionUID = -2213838555515605475L;


    /**
     * 交易产生的日期，格式为：yyyyMMdd示例:20201218
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "billDate长度不能超过8")
    private String billDate;

    /**
     * 账单类型：0-退款账单；1-支付账单；2-分账账单；3-分账退回账单
     * <p>
     * (必填)
     */
    @NotNull
    private Integer fileType;

    /**
     * 支付平台：1-支付宝；2-微信；6-银联云闪付；当账单类型为0-退款账单和1-支付账单时必填
     * <p>
     * (特殊必填)
     */
    private Integer payPlatform;

    @Override
    public Class<UmpayTradeBillDownloadResponse> getResponseClass() {
        return UmpayTradeBillDownloadResponse.class;
    }
}