/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.request.fund;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.fund.UmpayMerchantStopRemitResponse;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 商户停止出款请求
 *
 * @author liluqing
 * @version UmpayMerchantStopRemitRequest.java, v 0.1 2022-10-12 17:12
 */
@Data
public class UmpayMerchantStopRemitRequest extends UmBizRequest<UmpayMerchantStopRemitResponse> {

    /**
     * 聚合收单平台为商户分配的唯一 ID,商户入驻成功后由平台返回
     */
    @NotNull
    private String storeId;

    @Override
    public Class<UmpayMerchantStopRemitResponse> getResponseClass() {
        return UmpayMerchantStopRemitResponse.class;
    }
}