/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.merchant.*;
import com.fshows.umpay.sdk.request.merchant.wx.*;
import com.fshows.umpay.sdk.response.merchant.*;
import com.fshows.umpay.sdk.response.merchant.wx.*;
import org.apache.commons.lang3.StringUtils;

/**
 * 商户API枚举
 *
 * @author youmingming
 * @version UmMerchantApiEnum.java, v 0.1 2022-02-09 下午10:41 youmingming
 */
public enum UmMerchantApiEnum implements UmpayApiDefinition {
    // 商户入驻/修改/查询
    MERCHANT_ENTER(
            "商户入驻",
            "aggregation.merchant.enter",
            AggregationMerchantEnterRequest.class,
            AggregationMerchantEnterResponse.class
    ),
    MERCHANT_MODIFY(
            "商户信息修改",
            "aggregation.merchant.modify",
            AggregationMerchantModifyRequest.class,
            AggregationMerchantEnterResponse.class
    ),
    MERCHANT_SIGN(
            "支付平台签约",
            "aggregation.merchant.sign",
            UmpayMerchantSignRequest.class,
            UmpayMerchantSignResponse.class
    ),
    MERCHANT_QUERY(
            "商戶信息查詢",
            "merchant.info.select",
            AggregationMerchantQueryRequest.class,
            AggregationMerchantQueryResponse.class
    ),
    // 结算信息变更
    SUBMERCHANT_BANK_BIND(
            "商户结算信息变更",
            "liquidation.submerchant.bank.bind",
            UmpaySubmerchantBankBindRequest.class,
            UmpaySubmerchantBankBindResponse.class
    ),
    // 费率相关
    SUBMERCHANT_RATE_QUERY(
            "查询商户终端费率（单个）",
            "liquidation.submerchant.rate.query",
            UmpaySubmerchantRateQueryRequest.class,
            UmpaySubmerchantRateQueryResponse.class
    ),
    AGGREGATION_STORE_RATE_QUERY(
            "查询商户终端费率（所有）",
            "aggregation.store.rate.query",
            UmpayAggregationStoreRateQueryRequest.class,
            UmpayAggregationStoreRateQueryResponse.class
    ),
    SUBMERCHANT_RATE_UPDATE(
            "商户终端费率修改",
            "business.rate.set",
            UmpaySubmerchantRateUpdateRequest.class,
            UmpaySubmerchantRateUpdateResponse.class
    ),
    // 微信配置相关
    WX_PAY_CONFIG(
            "微信支付配置",
            "liquidation.wx.submerchant.config.create.supplement",
            UmpayWxPayConfigRequest.class,
            UmpayWxPayConfigResponse.class
    ),
    // 微信配置相关查询
    WX_PAY_CONFIG_QUERY(
            "微信配置查询",
            "liquidation.wx.merchant.setting.query",
            UmpayWxPayConfigQueryRequest.class,
            UmpayWxPayConfigQueryResponse.class
    ),
    WX_MERCHANT_STATE_QUERY(
            "微信授权状态查询",
            "liquidation.wx.merchant.state.query",
            UmpayWxMerchantStateQueryRequest.class,
            UmpayWxMerchantStateQueryResponse.class
    ),
    WX_APPLYMENT_CREATE(
            "微信实名认证-提交申请单",
            "merchant.wx.applyment.create",
            UmpayWxApplymentCreateRequest.class,
            UmpayWxApplymentCreateResponse.class
    ),
    WX_APPLYMENT_CANCEL(
            "微信实名认证-撤销申请单",
            "merchant.wx.applyment.cancel",
            UmpayWxApplymentCancelRequest.class,
            UmpayWxApplymentCancelResponse.class
    ),
    WX_APPLYMENT_QUERY(
            "微信实名认证-查询申请单审核状态",
            "merchant.wx.applyment.query",
            UmpayWxApplymentQueryRequest.class,
            UmpayWxApplymentQueryResponse.class
    ),

    SUBMERCHANT_UPDATE(
            "商户简称修改",
            "aggregation.submerchant.update",
            AggregationSubmerchantUpdateRequest.class,
            AggregationSubmerchantUpdateResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    UmMerchantApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmMerchantApiEnum getByValue(String value) {
        UmMerchantApiEnum[] valueList = UmMerchantApiEnum.values();
        for (UmMerchantApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    /**
     * Getter method for property <tt>requestClass</tt>.
     *
     * @return property value of requestClass
     */
    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}