/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.response.trade.pay.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 交易支付使用的资金渠道，支付宝交易时有返回,具体请查看&lt;支付宝官方文档&gt;
 *
 * @author liluqing
 * @version UmpayFundBillResponse.java, v 0.1 2022-03-16 12:02
 */
@Data
public class UmpayFundBillResponse implements Serializable {

    private static final long serialVersionUID = 8870834122164411744L;

    /**
     * 交易使用的资金渠道示例:ALIPAYACCOUNT
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "fundChannel长度不能超过32")
    private String fundChannel;

    /**
     * 该支付工具类型所使用的金额
     * <p>
     * (选填)
     */
    private BigDecimal amount;

    /**
     * 渠道实际付款金额
     * <p>
     * (选填)
     */
    private BigDecimal realAmount;

    /**
     * 渠道所使用的资金类型，只有在资金渠道（fund_channel）是银行卡渠道时才有返回。DEBIT_CARD:借记卡；CREDIT_CARD:信用卡；MIXED_CARD:借贷合一卡
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "fundType长度不能超过32")
    private String fundType;
}