/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.trade.pay;

import com.fshows.umpay.sdk.response.trade.pay.item.UmpayRiskInfoResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 统一下单响应参数
 *
 * @author
 * @version UmpayPrePayResponse.java, v 0.1 2022-03-16 13:35:53
 */
@Data
public class UmpayPrePayResponse implements Serializable {

    private static final long serialVersionUID = -2213838555464309667L;


    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 服务商订单号,64个字符以内。可包含字母、数字、下划线;需保证在接入的服务商系统中不重复
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outTradeNo长度不能超过64")
    private String outTradeNo;

    /**
     * 聚合收单平台产生的订单号，在系统内唯一
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

    /**
     * 订单总金额单位为元，精确到小数点后两位，取值范围[0.01,100000000]
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal totalAmount;

    /**
     * 订单类型为2-native支付时返回，可直接通过该链接生成二维码扫码支付
     * <p>
     * (特殊必填)
     */
    @Length(max = 1024, message = "qrCode长度不能超过1024")
    private String qrCode;

    /**
     * 支付平台：1-支付宝；2-微信；6-云闪付
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "payPlatformType长度不能超过1")
    private String payPlatformType;

    /**
     * 付款用户id，“微信sub_openid”，“支付宝 user_id”，“云闪付 user_id”
     * <p>
     * (选填)
     */
    @Length(max = 128, message = "userId长度不能超过128")
    private String userId;

    /**
     * pull_up_type为1时有值，服务商可根据返回的Json字符串信息调用官方接口拉起支付
     * <p>
     * (特殊必填)
     */
    private String miniPayInfo;
    /**
     * 支付链接，pay_platform_type=6-云闪付时返回；
     */
    private String jspayUrl;
    /**
     * 风险控制信息
     * <p>
     * (选填)
     */
    private UmpayRiskInfoResponse riskInfo;
    /**
     * 通道商户号微信、支付宝、云闪付的商户商编
     *
     * (特殊必填)
     */
    private String subMerchantNo;
    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在服务商系统中唯一
     *
     * (必填)
     */
    private String merchantId;
    /**
     * 1:支付宝线下支付,  3:微信线下支付, 16:银行卡收单借记, 17:银行卡收单贷记, 20:银联线下支付,  232:微信0费率行业, 233:微信0.1费率行业, 234:微信0.3费率行业, 235:微信0.38费率行业, 236:微信0.6费率行业, 300:支付宝0费率行业, 301:支付宝0.1费率行业，241:普通支付宝预授权，242:普通微信预授权，243:普通银联二维码预授权，244:普通支付宝预授权完成，245:普通微信预授权完成，246:普通银联二维码预授权完成
     * 注：银行卡和银联二维码等区分借贷记的交易类型，仅在订单状态为1-支付成功才为准确类型。其他订单状态下该参数不准确
     */
    private String payType;
}