/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.merchant.wx;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 微信实名认证-查询申请单审核状态
 *
 * @author
 * @version UmpayWxApplymentQueryResponse.java, v 0.1 2022-03-16 16:14:17
 */
@Data
public class UmpayWxApplymentQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555566779027L;


    /**
     * 申请单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "applymentId长度不能超过64")
    private String applymentId;

    /**
     * 服务商申请单编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "businessCode长度不能超过128")
    private String businessCode;

    /**
     * 申请单状态：0、【申请中】1、【授权校验失败】3、【图片上传失败】4、【申请受理成功】5、【申请受理失败】6、APPLYMENT_STATE_WAITTING_FOR_AUDIT：【审核中】；7、APPLYMENT_STATE_EDITTING：【编辑中】；8、APPLYMENT_STATE_FREEZED：【已冻结】；9、APPLYMENT_STATE_WAITTING_FOR_CONFIRM_CONTACT：【待确认联系信息】；10、APPLYMENT_STATE_WAITTING_FOR_CONFIRM_LEGALPERSON：【待账户验证】；11、APPLYMENT_STATE_PASSED：【审核通过】；12、APPLYMENT_STATE_REJECTED：【审核驳回】；13、APPLYMENT_STATE_CANCELED：【已作废】6-13请参考微信文档微信实名认证申请单状态说明
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "applymentState长度不能超过64")
    private String applymentState;

    /**
     * 二维码图片
     *
     * (选填)
     */
    @Length(max = 30000, message = "qrcodeData长度不能超过30000")
    private String qrcodeData;

    /**
     * 当申请单状态为“审核驳回”时，会返回该字段，标识被驳回的字段名
     *
     * (选填)
     */
    @Length(max = 256, message = "rejectParam长度不能超过256")
    private String rejectParam;

    /**
     * 当申请单状态为“审核驳回”时，该字段返回驳回原因，其他情况返回状态描述
     *
     * (选填)
     */
    @Length(max = 1024, message = "remark长度不能超过1024")
    private String remark;

}