/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.response.activity.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 多活动申请返回结果
 *
 * @author liluqing
 * @version UmpayMultiResultResponse.java, v 0.1 2022-03-16 16:47
 */
@Data
public class UmpayMultiResultResponse implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;
    /**
     * 申请单ID
     *
     * (选填)
     */
    @Length(max = 64, message = "orderId长度不能超过64")
    private String orderId;

    /**
     * 活动类型
     *
     * (选填)
     */
    @Length(max = 32, message = "activityType长度不能超过32")
    private String activityType;

    /**
     * 审核结果：0-审核中，1-审核成功；2-审核失败
     *
     * (选填)
     */
    @Length(max = 32, message = "auditResult长度不能超过32")
    private String auditResult;

    /**
     * 失败理由
     *
     * (选填)
     */
    @Length(max = 512, message = "failReason长度不能超过512")
    private String failReason;

}