/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.activity;

import com.fshows.umpay.sdk.response.activity.item.UmpayMultiResultResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.List;

/**
 * 支付宝活动审核状态查询接口
 *
 * @author
 * @version UmpayAlipayActivityQueryResponse.java, v 0.1 2022-03-16 16:47:19
 */
@Data
public class UmpayAlipayActivityQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555843174513L;


    /**
     * 聚合收单平台为商户分配的唯一&nbsp;ID,商户入驻后由平台返回；
     *
     * (特殊必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在系统中唯一；
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "merchantId长度不能超过32")
    private String merchantId;

    /**
     * 支付宝子商户号（一个商户含多个子商户号的情况下必填）
     *
     * (特殊必填)
     */
    @Length(max = 16, message = "alipayId长度不能超过16")
    private String alipayId;

    /**
     * 多活动申请返回结果
     *
     * (选填)
     */
    private List<UmpayMultiResultResponse> multiResult;

}