/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.trade.order;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.trade.order.UmpayRefundQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author
 * @version UmpayRefundQueryRequest.java, v 0.1 2022-03-16 14:23:42
 */
@Data
public class UmpayRefundQueryRequest extends UmBizRequest<UmpayRefundQueryResponse> {

    private static final long serialVersionUID = -2213838555435596567L;


    /**
     * 服务商的订单号,64个字符以内。可包含字母、数字、下划线;需保证在接入的服务商系统中唯一；部分退款不可根据此订单号查询；
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "outTradeNo长度不能超过64")
    private String outTradeNo;

    /**
     * 聚合收单平台订单；部分退款不可根据此订单号查询；
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

    /**
     * 服务商外部退款号查询部分退款时out_refund_no和refund_no二选一必填
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "outRefundNo长度不能超过32")
    private String outRefundNo;

    /**
     * 聚合收单平台退款号 （这4个参数至少有一个不为空）查询部分退款时out_refund_no和refund_no二选一必填
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "refundNo长度不能超过32")
    private String refundNo;

    @Override
    public Class<UmpayRefundQueryResponse> getResponseClass() {
        return UmpayRefundQueryResponse.class;
    }
}