/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.trade.order;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.trade.order.UmpayOrderCloseResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 订单关闭请求
 *
 * @author
 * @version UmpayOrderCloseRequest.java, v 0.1 2022-03-16 14:14:11
 */
@Data
public class UmpayOrderCloseRequest extends UmBizRequest<UmpayOrderCloseResponse> {

    private static final long serialVersionUID = -2213838555271374533L;


    /**
     * 服务商的订单号,64个字符以内。可包含字母、数字、下划线;需保证在接入的服务商系统中唯一
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "outTradeNo长度不能超过64")
    private String outTradeNo;

    /**
     * 聚合收单平台订单
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

    @Override
    public Class<UmpayOrderCloseResponse> getResponseClass() {
        return UmpayOrderCloseResponse.class;
    }
}