/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.request.merchant.item.UmpayMerchantRateRequest;
import com.fshows.umpay.sdk.response.merchant.UmpaySubmerchantRateUpdateResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 商户终端费率修改
 *
 * @author
 * @version UmpaySubmerchantRateUpdateRequest.java, v 0.1 2022-03-16 15:30:47
 */
@Data
public class UmpaySubmerchantRateUpdateRequest extends UmBizRequest<UmpaySubmerchantRateUpdateResponse> {

    private static final long serialVersionUID = -2213838555414473447L;


    /**
     * 商户ID
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 商户费率合集
     * <p>
     * (特殊必填)
     */
    private List<UmpayMerchantRateRequest> merchantRateList;

    @Override
    public Class<UmpaySubmerchantRateUpdateResponse> getResponseClass() {
        return UmpaySubmerchantRateUpdateResponse.class;
    }

}