/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.AggregationMerchantQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 商户信息查询
 *
 * @author
 * @version AggregationMerchantQueryRequest.java, v 0.1 2022-03-16 15:08:39
 */
@Data
public class AggregationMerchantQueryRequest extends UmBizRequest<AggregationMerchantQueryResponse> {

    private static final long serialVersionUID = -2213838555789127157L;


    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在服务商系统中唯一
     * <p>
     * (特殊必填)
     */
    @Length(max = 20, message = "merchantId长度不能超过20")
    private String merchantId;

    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     * <p>
     * (特殊必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    @Override
    public Class<AggregationMerchantQueryResponse> getResponseClass() {
        return AggregationMerchantQueryResponse.class;
    }
}