/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.trade.order.UmpayFeeSubsidyUploadRequest;
import com.fshows.umpay.sdk.request.trade.order.UmpayOrderCloseRequest;
import com.fshows.umpay.sdk.request.trade.order.UmpayOrderQueryRequest;
import com.fshows.umpay.sdk.request.trade.order.UmpayOrderRefundRequest;
import com.fshows.umpay.sdk.request.trade.order.UmpayRefundQueryRequest;
import com.fshows.umpay.sdk.request.trade.order.UmpayUnionQueryUseridRequest;
import com.fshows.umpay.sdk.request.trade.pay.UmpayGetWxFaceAuthInfoRequest;
import com.fshows.umpay.sdk.request.trade.pay.UmpayPrePayRequest;
import com.fshows.umpay.sdk.request.trade.pay.UmpayScanCardRequest;
import com.fshows.umpay.sdk.response.trade.order.UmpayFeeSubsidyUploadResponse;
import com.fshows.umpay.sdk.response.trade.order.UmpayOrderCloseResponse;
import com.fshows.umpay.sdk.response.trade.order.UmpayOrderQueryResponse;
import com.fshows.umpay.sdk.response.trade.order.UmpayOrderRefundResponse;
import com.fshows.umpay.sdk.response.trade.order.UmpayRefundQueryResponse;
import com.fshows.umpay.sdk.response.trade.order.UmpayUnionQueryUseridResponse;
import com.fshows.umpay.sdk.response.trade.pay.UmpayGetWxFaceAuthInfoResponse;
import com.fshows.umpay.sdk.response.trade.pay.UmpayPrePayResponse;
import com.fshows.umpay.sdk.response.trade.pay.UmpayScanCardResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * 交易api枚举
 *
 * @author liluqing
 * @version UmTradeApiEnum.java, v 0.1 2022-02-09 下午10:41 liluqing
 */
public enum UmTradeApiEnum implements UmpayApiDefinition {

    SCAN_CARD_PAY(
            "条码支付（被扫：B扫C）",
            "aggregation.barcode.pay",
            UmpayScanCardRequest.class,
            UmpayScanCardResponse.class
    ),
    PRE_PAY(
            "统一支付（主扫：C扫B）",
            "aggregation.prepay",
            UmpayPrePayRequest.class,
            UmpayPrePayResponse.class
    ),
    ORDER_QUERY(
            "订单查询",
            "aggregation.pay.query",
            UmpayOrderQueryRequest.class,
            UmpayOrderQueryResponse.class
    ),
    ORDER_CLOSE("订单关闭",
            "liquidation.order.close",
            UmpayOrderCloseRequest.class,
            UmpayOrderCloseResponse.class
    ),
    ORDER_REFUND(
            "订单退款",
            "aggregation.pay.refund",
            UmpayOrderRefundRequest.class,
            UmpayOrderRefundResponse.class
    ),
    REFUND_QUERY(
            "订单退款查询",
            "aggregation.pay.refund.query",
            UmpayRefundQueryRequest.class,
            UmpayRefundQueryResponse.class
    ),
    GET_WX_FACE_AUTH_INFO(
            "获取微信刷脸授权信息",
            "liquidation.wx.face.get_wxpayface_authinfo",
            UmpayGetWxFaceAuthInfoRequest.class,
            UmpayGetWxFaceAuthInfoResponse.class
    ),
    UNION_QUERY_USERID(
            "银联云闪付获取用户标识",
            "aggregation.union.query.userid",
            UmpayUnionQueryUseridRequest.class,
            UmpayUnionQueryUseridResponse.class
    ),
    ORDER_FEE_SUBSIDY_UPLOAD(
            "手续费补贴金上传",
            "order.fee.subsidy.upload",
            UmpayFeeSubsidyUploadRequest.class,
            UmpayFeeSubsidyUploadResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    UmTradeApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmTradeApiEnum getByValue(String value) {
        UmTradeApiEnum[] valueList = UmTradeApiEnum.values();
        for (UmTradeApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    /**
     * Getter method for property <tt>requestClass</tt>.
     *
     * @return property value of requestClass
     */
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}