/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.activity.UmpayAlipayActivityApplyRequest;
import com.fshows.umpay.sdk.request.activity.UmpayAlipayActivityQueryRequest;
import com.fshows.umpay.sdk.request.activity.UmpayWxActivityApplyRequest;
import com.fshows.umpay.sdk.request.activity.UmpayWxActivityQueryRequest;
import com.fshows.umpay.sdk.request.machine.UmpayMachineBindOrUnBindRequest;
import com.fshows.umpay.sdk.request.machine.UmpayMachineQueryRequest;
import com.fshows.umpay.sdk.response.activity.UmpayAlipayActivityApplyResponse;
import com.fshows.umpay.sdk.response.activity.UmpayAlipayActivityQueryResponse;
import com.fshows.umpay.sdk.response.activity.UmpayWxActivityApplyResponse;
import com.fshows.umpay.sdk.response.activity.UmpayWxActivityQueryResponse;
import com.fshows.umpay.sdk.response.machine.UmpayMachineBindOrUnBindResponse;
import com.fshows.umpay.sdk.response.machine.UmpayMachineQueryResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * 活动API枚举
 *
 * @author youmingming
 * @version UmMerchantApiEnum.java, v 0.1 2022-02-09 下午10:41 youmingming
 */
public enum UmMachineApiEnum implements UmpayApiDefinition {

    MACHINE_BIND_OR_UNBIND(
            "设备的绑定和解绑",
            "terminal.bind.or.unbind",
            UmpayMachineBindOrUnBindRequest.class,
            UmpayMachineBindOrUnBindResponse.class
    ),
    MACHINE_QUERY(
            "设备信息查询",
            "terminal.band.status.query",
            UmpayMachineQueryRequest.class,
            UmpayMachineQueryResponse.class
    )
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    UmMachineApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmMachineApiEnum getByValue(String value) {
        UmMachineApiEnum[] valueList = UmMachineApiEnum.values();
        for (UmMachineApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    /**
     * Getter method for property <tt>requestClass</tt>.
     *
     * @return property value of requestClass
     */
    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return this.responseClass;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}