/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.client;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.exception.UmPayException;
import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.UmBaseResponse;

/**
 * @author youmingming
 * @version UmBaseClient.java, v 0.1 2022-02-09 下午10:35 youmingming
 */
public interface UmBaseClient {
    /**
     * 请求联动接口
     *
     * @param request            请求参数
     * @param umpayApiDefinition 方法枚举
     * @param <R>                返参
     * @return UmBaseResponse
     *
     * UmpayApiDefinition api方法请参考下列API枚举
     * @see com.fshows.umpay.sdk.enums.UmActivityApiEnum
     * @see com.fshows.umpay.sdk.enums.UmFundApiEnum
     * @see com.fshows.umpay.sdk.enums.UmMerchantApiEnum
     * @see com.fshows.umpay.sdk.enums.UmPictureApiEnum
     * @see com.fshows.umpay.sdk.enums.UmTerminalApiEnum
     * @see com.fshows.umpay.sdk.enums.UmTradeApiEnum
     */
    <R> UmBaseResponse<R> excute(UmBizRequest<R> request, UmpayApiDefinition umpayApiDefinition, String url) throws UmPayException;
}
