/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.shande.sdk;

import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.fshows.com.shande.openapi.sdk.client.OpenParameters;
import com.fshows.com.shande.openapi.sdk.client.ShandeOpenApiClient;
import com.fshows.com.shande.openapi.sdk.config.Configuration;
import com.fshows.com.shande.openapi.sdk.config.FileConfiguration;
import com.fshows.com.shande.openapi.sdk.util.JsonHumpLineUtils;
import com.fshows.shande.sdk.common.ShandeApiEnum;
import com.fshows.shande.sdk.common.ShandeException;
import com.fshows.shande.sdk.common.ValidateUtil;
import com.fshows.shande.sdk.request.FileDownloadRequest;
import com.fshows.shande.sdk.request.ShandeRequest;
import com.fshows.shande.sdk.request.item.file.BizData;
import com.fshows.shande.sdk.response.ShandeResponseBody;
import java.lang.reflect.Type;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShandeRequestClient
extends ShandeOpenApiClient {
    private static final Logger log = LoggerFactory.getLogger(ShandeRequestClient.class);
    public static final String REQUEST_SUCCESS_CODE = "0000";
    public static final String RESULT_EMPTY_ARRAY = "[]";
    private static final String FILE_SEPARATOR = SystemUtil.getOsInfo().getFileSeparator();
    private static SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();
    private static ParserConfig CAMEL_CASE_CONFIG = new ParserConfig();

    public ShandeRequestClient(Configuration configuration) {
        super(configuration);
    }

    public <T> ShandeResponseBody<T> request(ShandeApiEnum apiEnum, ShandeRequest request) throws ShandeException {
        long startTime = System.currentTimeMillis();
        if (super.getConfiguration().checkParam().booleanValue()) {
            ValidateUtil.validateWithThrow(request, new Class[0]);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
        String param = JsonHumpLineUtils.transLine(jsonObject).toJSONString();
        OpenParameters context = new OpenParameters.Builder().apiName(apiEnum.getValue()).param(param).verifyTypeEnum(apiEnum.getVerifyTypeEnum()).build();
        try {
            JSONObject dataResult;
            String result = this.send(context);
            JSONObject jsonResult = JSON.parseObject((String)result);
            log.info("request >> \u886b\u5fb7\u8bf7\u6c42\u670d\u52a1\u51fa\u5165\u53c2 >> url = {}, request = {}, result = {}, \u8017\u65f6={}ms", new Object[]{this.getConfiguration().remoteAddress() + apiEnum.getValue(), context.getParams(), result, System.currentTimeMillis() - startTime});
            if (!StrUtil.equalsIgnoreCase((CharSequence)jsonResult.getString("responseCode"), (CharSequence)REQUEST_SUCCESS_CODE)) {
                throw new ShandeException(jsonResult.getString("responseCode"), jsonResult.getString("responseDesc"), new Object[0]);
            }
            String dataStr = jsonResult.getString("data");
            if (StrUtil.isNotBlank((CharSequence)dataStr) && !RESULT_EMPTY_ARRAY.equals(dataStr) && StrUtil.isNotBlank((CharSequence)(dataResult = JSON.parseObject((String)dataStr)).getString("code"))) {
                String issue = dataResult.getString("issue");
                String message = dataResult.getString("message");
                String errorMsg = StrUtil.isNotBlank((CharSequence)issue) ? issue : message;
                throw new ShandeException(dataResult.getString("code"), errorMsg, new Object[0]);
            }
            ShandeResponseBody<Object> response = new ShandeResponseBody<Object>();
            response.setData(JSON.parseObject((String)jsonResult.getString("data"), (Type)apiEnum.getResponseClass(), (ParserConfig)CAMEL_CASE_CONFIG, (Feature[])new Feature[0]));
            response.setResponseCode(jsonResult.getString("responseCode"));
            response.setResponseDesc(jsonResult.getString("responseDesc"));
            response.setResponseTime(jsonResult.getString("responseTime"));
            response.setCustomerOrderNo(jsonResult.getString("customerOrderNo"));
            return response;
        }
        catch (ShandeException e) {
            log.error("request >> \u886b\u5fb7\u8bf7\u6c42\u670d\u52a1\u4e1a\u52a1\u5f02\u5e38 >> apiEnum = {}, request = {}, exception = {}", new Object[]{apiEnum.getValue(), request, ExceptionUtils.getStackTrace((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            log.error("request >> \u886b\u5fb7\u8bf7\u6c42\u670d\u52a1\u5f02\u5e38 >> apiEnum = {}, request = {}, exception = {}", new Object[]{apiEnum.getValue(), request, ExceptionUtils.getStackTrace((Throwable)e)});
            throw ShandeException.SERVER_EXCEPTION;
        }
    }

    public String downloadFile(FileDownloadRequest request) {
        ShandeApiEnum apiEnum = ShandeApiEnum.CUS_OPEN;
        log.info("request >> \u886b\u5fb7\u8bf7\u6c42\u5f00\u59cb >> apiEnum = {}, request = {}", (Object)apiEnum, (Object)request);
        BizData bizData = request.getBizData();
        bizData.setMerchantNo(this.getConfiguration().mid());
        ValidateUtil.validateWithThrow(request, new Class[0]);
        String fileName = request.getFileName();
        OpenParameters context = new OpenParameters.Builder().apiName(apiEnum.getValue()).fileName(fileName).param(JSON.toJSONString((Object)request)).verifyTypeEnum(apiEnum.getVerifyTypeEnum()).build();
        try {
            this.downloadFile(context);
            return ((FileConfiguration)this.getConfiguration()).storagePath() + FILE_SEPARATOR + fileName + "." + request.getFileType();
        }
        catch (Exception e) {
            log.error("request >> \u886b\u5fb7\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38 >> apiEnum = {},  exception = {}, request = {}", new Object[]{apiEnum, ExceptionUtils.getStackTrace((Throwable)e), request});
            throw ShandeException.SERVER_EXCEPTION;
        }
    }

    static {
        ShandeRequestClient.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
        ShandeRequestClient.CAMEL_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.CamelCase;
    }
}

