/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.com.shande.openapi.sdk.util;

import com.fshows.com.shande.openapi.sdk.util.CertFileUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class RSAUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAUtils.class);
    private static final String SHA1_WITH_RSA = "SHA1WithRSA";
    private static final String SHA1 = "SHA1";

    public static String signature(String data, String privateKey) throws Exception {
        Signature signature = Signature.getInstance(SHA1_WITH_RSA);
        signature.initSign(CertFileUtils.toPrivateKey(privateKey));
        signature.update(data.getBytes());
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static boolean verifySignature(String data, String signature, String publicKey) throws Exception {
        PublicKey pubKey = CertFileUtils.toPublicKey(publicKey);
        Signature sign = Signature.getInstance(SHA1_WITH_RSA);
        sign.initVerify(pubKey);
        sign.update(data.getBytes(StandardCharsets.UTF_8));
        return sign.verify(Base64.decodeBase64((String)signature));
    }

    public static String detachSign(byte[] dataBytes, String privateKey) throws Exception {
        Signature signature = Signature.getInstance(SHA1_WITH_RSA);
        signature.initSign(CertFileUtils.toPrivateKey(privateKey));
        signature.update(dataBytes, 0, dataBytes.length);
        return RSAUtils.base64Encode(RSAUtils.createPkcs7(signature.sign()));
    }

    private static byte[] createPkcs7(byte[] signedDataBytes) throws NoSuchAlgorithmException, IOException {
        AlgorithmId[] digestAlgorithmIds = new AlgorithmId[]{AlgorithmId.get(SHA1)};
        ContentInfo contentInfo = new ContentInfo(ContentInfo.DATA_OID, null);
        X509Certificate certificate = RSAUtils.getSignCert("configuration.pfxFileName()", "configuration.pfxPassword()");
        if (certificate != null) {
            X509Certificate[] certificates = new X509Certificate[]{certificate};
            SignerInfo si = new SignerInfo((X500Name)certificate.getIssuerDN(), certificate.getSerialNumber(), AlgorithmId.get(SHA1), null, new AlgorithmId(AlgorithmId.RSAEncryption_oid), signedDataBytes, null);
            SignerInfo[] signerInfo = new SignerInfo[]{si};
            PKCS7 p7 = new PKCS7(digestAlgorithmIds, contentInfo, certificates, signerInfo);
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                p7.encodeSignedData(bout);
                byte[] byArray = bout.toByteArray();
                return byArray;
            }
        }
        throw new IllegalArgumentException("something wrong with cert file, pls check it!");
    }

    private static X509Certificate getSignCert(String pfxFileName, String pfxPassword) {
        try {
            KeyStore keyStore = CertFileUtils.getKeyStore(pfxFileName, pfxPassword);
            String keyAlias = CertFileUtils.getKeyAlias(keyStore);
            return (X509Certificate)keyStore.getCertificate(keyAlias);
        }
        catch (Exception e) {
            LOGGER.error("get sign cert error ", (Throwable)e);
            return null;
        }
    }

    private static String base64Encode(byte[] data) {
        String strRet = Base64.encodeBase64String((byte[])data);
        strRet = strRet.replaceAll("\r\n", "");
        strRet = strRet.replaceAll("\n", "");
        strRet = strRet.replaceAll(" ", "");
        strRet = strRet.replaceAll("\t", "");
        return strRet;
    }

    public static boolean detachVerify(byte[] originData, String signedData) throws NoSuchAlgorithmException, SignatureException, IOException {
        if (signedData == null) {
            throw new IllegalArgumentException("signedData can't be null");
        }
        PKCS7 exp = new PKCS7(Base64.decodeBase64((String)signedData));
        SignerInfo[] signers = originData == null ? exp.verify() : exp.verify(originData);
        if (signers != null) {
            X509Certificate[] certs = exp.getCertificates();
            return certs[0].getSerialNumber().equals(signers[0].getCertificateSerialNumber());
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        String rsaKey = CertFileUtils.getPrivateKeyFromPfxFile("Merchant_Private_CFCA_sandbox.pfx", "11111111");
        System.out.println(rsaKey);
        String data = "testInfo";
        String signResult = RSAUtils.signature(data, rsaKey);
        String publicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnORAIOgdgIfkV/FUxyzNUF/nPz03YqThw3qdOERgAf7Hpzqc4newR3MXt/FNSefPBG+I/L8LQxJTlk3Rn3EcL/Vq/7Xw2SMMr3Xz/CkfwRsZ9CSN6pI+zKE86xvHkGvLvTYSDmX40XpaUhIyJ7+KTc/Gnzu44ctWHzSAeQaFnu2nPMhDThL2Dcbfcj+qBSoberdcCgreW/ul9HQUykkIva8oHQagI+vK4vlqbLDHaJfvmR+Y3ny+3N4QATULwjBIPn4zBDjgrbQiegskxsUTwtCGVpXivT4ZJdOXpIAm2aELRnqr1OOjMO3s00TmMmdh3NFrXink5cRJaz/GkYM4lQIDAQAB";
        System.out.println(RSAUtils.verifySignature(data, signResult, publicKey));
    }
}

