/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.sdk.sf.api.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Misc {
    public static final String NONE = "";
    public static final String NULL = "null";
    public static final String UNDEFINED = "undefined";
    public static final Pattern PATTERN = Pattern.compile("[0-9]*");

    public static boolean isNull(Object obj) {
        return Misc.isEmpty(obj);
    }

    public static boolean isNotNull(Object obj) {
        return !Misc.isEmpty(obj);
    }

    public static boolean isNotEmpty(Object obj) {
        return !Misc.isEmpty(obj);
    }

    public static boolean isEmpty(Object obj) {
        String str;
        if (obj == null) {
            return true;
        }
        if (obj instanceof String && (NONE.equals(str = obj.toString().trim()) || NULL.equals(str) || UNDEFINED.equals(str))) {
            return true;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        if (Misc.isNull(str)) {
            return false;
        }
        Matcher isNum = PATTERN.matcher(str);
        return isNum.matches();
    }

    public static Set<String> string2Set(String values, String split) {
        HashSet<String> set = new HashSet<String>();
        if (Misc.isNull(values)) {
            return set;
        }
        values = values.replace("\uff0c", ",");
        StringTokenizer st = new StringTokenizer(values, split);
        while (st.hasMoreTokens()) {
            String value = st.nextToken().trim();
            if (Misc.isNull(value)) continue;
            set.add(value);
        }
        return set;
    }
}

