/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.sdk.sf.api.utils;

import com.alibaba.fastjson.JSON;
import com.fshows.sdk.sf.api.utils.LogUtil;
import com.fshows.sdk.sf.api.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsRequestUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"FsRequestLog");
    private static final int DEFAULT_REQUEST_TIME_OUT = 10000;
    private static final int DEFAULT_CONNECT_TIME_OUT = 5000;
    private static final int DEFUALT_GET_CONNECTION_TIME_OUT = 5000;
    private static final int DEFAULT_MAX_TOTAL = 5000;
    private static final int DEFAULT_MAX_PER_ROUT = 1000;
    private static final String DEFUALT_HTTP_CONTENT_TYPE_VALUE = "application/x-www-form-urlencoded";
    private static final String XML_CONTENT_TYPE = "application/xml";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String DEFUALT_CHARSET_HEADER = "charset=utf-8";
    private static final String DEFUALT_HTTP_CONTENT_TYPE_NAME = "Content-Type";
    private static final int LOG_SIZE_LIMITED = 10000;
    private static final int DEFAULT_SSL_SESSION_CACHE_SIZE = 5000;
    private static final int DEFAULT_SSL_SESSION_TIME_OUT = 15;
    private static final Object SYNCLOCK = new Object();
    private static CloseableHttpClient httpClient = null;

    private static void config(HttpRequestBase httpRequestBase, int timeout) throws URISyntaxException {
        timeout = timeout <= 0 ? 10000 : (timeout *= 1000);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(timeout).build();
        httpRequestBase.setConfig(requestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CloseableHttpClient getHttpClient() throws NoSuchAlgorithmException, KeyManagementException {
        if (httpClient == null) {
            Object object = SYNCLOCK;
            synchronized (object) {
                if (httpClient == null) {
                    httpClient = FsRequestUtil.createPoolHttpClient();
                }
            }
        }
        return httpClient;
    }

    private static CloseableHttpClient getBasicHttpClient(InputStream certStream, char[] password) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        Registry<ConnectionSocketFactory> registry = FsRequestUtil.getCertSSLRegistry(certStream, password);
        BasicHttpClientConnectionManager clientConnectionManager = new BasicHttpClientConnectionManager(registry);
        DefaultHttpRequestRetryHandler requestRetryHandler = new DefaultHttpRequestRetryHandler(0, false);
        return HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)requestRetryHandler).setConnectionManager((HttpClientConnectionManager)clientConnectionManager).build();
    }

    private static CloseableHttpClient createPoolHttpClient() throws KeyManagementException, NoSuchAlgorithmException {
        PoolingHttpClientConnectionManager clientConnectionManager = new PoolingHttpClientConnectionManager(FsRequestUtil.getDefaultSSLRegistry());
        clientConnectionManager.setMaxTotal(5000);
        clientConnectionManager.setDefaultMaxPerRoute(1000);
        DefaultHttpRequestRetryHandler requestRetryHandler = new DefaultHttpRequestRetryHandler(0, false);
        return HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)requestRetryHandler).setConnectionManager((HttpClientConnectionManager)clientConnectionManager).build();
    }

    private static Registry<ConnectionSocketFactory> getDefaultSSLRegistry() throws KeyManagementException, NoSuchAlgorithmException {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(FsRequestUtil.createIgnoreVerifyContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
    }

    private static Registry<ConnectionSocketFactory> getCertSSLRegistry(InputStream certStream, char[] password) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(FsRequestUtil.createSignedSSLContext(password, certStream), new String[]{"TLSv1"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        return RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
    }

    private static void setPostParams(HttpPost httpost, Map<String, String> params, String charset) throws UnsupportedEncodingException {
        List<NameValuePair> nvps = FsRequestUtil.convertParam(params);
        if (nvps == null) {
            return;
        }
        httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, charset));
    }

    private static List<NameValuePair> convertParam(Map<String, String> params) {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        if (params == null || params.size() <= 0) {
            return null;
        }
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            nvps.add((NameValuePair)new BasicNameValuePair(key, params.get(key)));
        }
        return nvps;
    }

    private static void setPostStringParams(HttpPost httpost, String type, String content, String charset) {
        if (!StringUtils.isBlank(content)) {
            ContentType contentType = ContentType.create((String)type, (String)charset);
            httpost.setEntity((HttpEntity)new StringEntity(content, contentType));
        }
    }

    private static void setHeaders(HttpRequestBase httpRequestBase, Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)httpRequestBase).setHeader(arg_0, arg_1));
        }
        httpRequestBase.removeHeaders("Connection");
        httpRequestBase.setHeader("Connection", "close");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String send(String url, HttpRequestBase requestBase, String charset, int timeout, Map<String, String> headers) throws IOException, URISyntaxException {
        if (StringUtils.isBlank(charset)) {
            charset = "UTF-8";
        }
        if (StringUtils.isBlank(url)) {
            throw new IllegalArgumentException("url is empty");
        }
        FsRequestUtil.config(requestBase, timeout);
        FsRequestUtil.setHeaders(requestBase, headers);
        try (CloseableHttpResponse response = FsRequestUtil.getHttpClient().execute((HttpUriRequest)requestBase, (HttpContext)HttpClientContext.create());){
            String string = FsRequestUtil.getResponseContent(charset, response);
            return string;
        }
        catch (IOException e) {
            LogUtil.error(log, "send http request error, url={},msg={}", e, url, e.getMessage());
            return null;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LogUtil.error(log, e.getMessage(), e);
        }
        return null;
    }

    private static String sendRequest(String url, String charset, Map<String, String> headers, int timeout, HttpPost post) throws IOException {
        try {
            return FsRequestUtil.send(url, (HttpRequestBase)post, charset, timeout, headers);
        }
        catch (URISyntaxException e) {
            LogUtil.error(log, "request url format error, url={},msg={}", e, url, e.getMessage());
            return null;
        }
    }

    private static void validatParam(String url, String json) {
        if (StringUtils.isBlank(url)) {
            throw new IllegalArgumentException("url is empty");
        }
        if (StringUtils.isBlank(json)) {
            throw new IllegalArgumentException("json data is empty");
        }
    }

    private static String getResponseContent(String charset, CloseableHttpResponse response) throws IOException {
        if (response == null) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        String result = null;
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (String)charset);
        }
        EntityUtils.consume((HttpEntity)entity);
        return result;
    }

    private static void logRequest(String url, String params, String headers, long begin, String result, long end) {
        if (StringUtils.isBlank(result)) {
            LogUtil.info(log, "request url={},time={}ms,param={},header={},response={}", url, end - begin, params, headers, "", result);
        } else if (result.length() <= 10000) {
            LogUtil.info(log, "request url={},time={}ms,param={},header={},response={}", url, end - begin, params, headers, result);
        }
    }

    private static SSLContext createIgnoreVerifyContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.getClientSessionContext().setSessionTimeout(15);
        sslContext.getClientSessionContext().setSessionCacheSize(5000);
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        return sslContext;
    }

    private static SSLContext createSignedSSLContext(char[] password, InputStream certStream) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(certStream, password);
        SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(keyStore, password).build();
        sslContext.getClientSessionContext().setSessionTimeout(15);
        sslContext.getClientSessionContext().setSessionCacheSize(5000);
        return sslContext;
    }

    private static String postByString(String url, String charset, String param, String mimeType, Map<String, String> headers, int timeout) throws IOException {
        FsRequestUtil.validatParam(url, param);
        long begin = System.currentTimeMillis();
        HttpPost post = new HttpPost(url);
        FsRequestUtil.setPostStringParams(post, mimeType, param, charset);
        String result = FsRequestUtil.sendRequest(url, charset, headers, timeout, post);
        long end = System.currentTimeMillis();
        FsRequestUtil.logRequest(url, param, JSON.toJSONString(headers), begin, result, end);
        return result;
    }

    public static String post(String url, String charset, Map<String, String> params, Map<String, String> headers, int timeout) throws IOException {
        if (StringUtils.isBlank(url)) {
            throw new IllegalArgumentException("url is empty");
        }
        HttpPost post = new HttpPost(url);
        FsRequestUtil.setPostParams(post, params, charset);
        long begin = System.currentTimeMillis();
        String result = FsRequestUtil.sendRequest(url, charset, headers, timeout, post);
        long end = System.currentTimeMillis();
        FsRequestUtil.logRequest(url, JSON.toJSONString(params), JSON.toJSONString(headers), begin, result, end);
        return result;
    }

    /*
     * Exception decompiling
     */
    public static String post(String url, InputStream certStream, char[] password, String charset, String params, String contentType, Map<String, String> headers, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String post(String url, Map<String, String> params, int timeout) throws IOException {
        return FsRequestUtil.post(url, "UTF-8", params, null, timeout);
    }

    public static String postByJson(String url, String json, int timeout) throws IOException {
        return FsRequestUtil.postByJson(url, "UTF-8", json, null, timeout);
    }

    public static String postByJson(String url, String charset, String json, Map<String, String> headers, int timeout) throws IOException {
        return FsRequestUtil.postByString(url, "UTF-8", json, JSON_CONTENT_TYPE, headers, timeout);
    }

    public static String postByXml(String url, String charset, String xml, Map<String, String> headers, int timeout) throws IOException {
        return FsRequestUtil.postByString(url, "UTF-8", xml, XML_CONTENT_TYPE, headers, timeout);
    }

    public static String postByXml(String url, String xml, int timeout) throws IOException {
        return FsRequestUtil.postByXml(url, "UTF-8", xml, null, timeout);
    }

    public static String get(String url, String charset, Map<String, String> params, Map<String, String> headers, int timeout) throws IOException {
        if (StringUtils.isBlank(url)) {
            throw new IllegalArgumentException("url is empty");
        }
        URI uri = null;
        try {
            long begin = System.currentTimeMillis();
            URIBuilder builder = new URIBuilder(url);
            if (params != null && params.size() > 0) {
                List<NameValuePair> nvps = FsRequestUtil.convertParam(params);
                builder.addParameters(nvps);
            }
            uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            String content = FsRequestUtil.send(url, (HttpRequestBase)httpGet, charset, timeout, headers);
            long end = System.currentTimeMillis();
            FsRequestUtil.logRequest(url, JSON.toJSONString(params), JSON.toJSONString(headers), begin, content, end);
            return content;
        }
        catch (URISyntaxException ex) {
            LogUtil.error(log, "request url format error, url={},msg={}", ex, url, ex.getMessage());
            return null;
        }
    }

    public static String get(String url, Map<String, String> params, int timeout) throws IOException {
        return FsRequestUtil.get(url, "UTF-8", params, null, timeout);
    }

    public static String get(String url, int timeout) throws IOException {
        return FsRequestUtil.get(url, null, timeout);
    }

    public static void closeClient() throws IOException {
        if (httpClient != null) {
            httpClient.close();
        }
    }
}

