/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.sdk.sf.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.sdk.sf.api.SfClient;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.SfResponse;
import com.fshows.sdk.sf.api.Signer;
import com.fshows.sdk.sf.api.enums.SfResultCodeEnum;
import com.fshows.sdk.sf.api.utils.FsRequestUtil;
import com.fshows.sdk.sf.api.utils.LogUtil;
import com.fshows.sdk.sf.api.utils.Misc;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSfClient
implements SfClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSfClient.class);
    private String serverUrl;
    private String devid;
    private String devKey;

    public DefaultSfClient(String serverUrl, String devid, String devKey) {
        this.serverUrl = serverUrl;
        this.devid = devid;
        this.devKey = devKey;
    }

    @Override
    public <T extends SfResponse<SfResponse>> T execute(SfRequest<T> request) {
        SfResponse<SfResponse> sfResponse = this.executeRequest(request);
        SfResponse t1 = (SfResponse)JSON.parseObject((String)JSONObject.toJSONString(sfResponse), request.getResponseClazz());
        SfResponse t2 = (SfResponse)JSON.parseObject((String)sfResponse.getResult(), request.getResponseClazz());
        t1.setData(t2);
        t1.setResult(null);
        return (T)t1;
    }

    @Override
    public <T extends SfResponse<SfResponse>> String executeString(SfRequest<T> request) {
        return this.executeRequest(request).getResult();
    }

    @Override
    public <T extends SfResponse<SfResponse>> List<T> executeArray(SfRequest<T> request) {
        String data = this.executeString(request);
        List response = JSON.parseArray((String)data, request.getResponseClazz());
        return response;
    }

    public SfResponse<SfResponse> executeRequest(SfRequest request) {
        JSONObject json = (JSONObject)JSON.parseObject((String)request.getBusinessParam(), JSONObject.class);
        json.put("dev_id", (Object)this.devid);
        String sign = Signer.sign(json.toString(), this.devid, this.devKey);
        String response = null;
        try {
            response = FsRequestUtil.postByJson(this.serverUrl + request.getApiMethodName().toLowerCase() + "?sign=" + sign, json.toString(), 10000);
        }
        catch (IOException e) {
            LogUtil.error(log, "\u987a\u4e30\u63a5\u53e3 >> \u8c03\u7528\u5f02\u5e38 >> param :{}", request);
            return new SfResponse<SfResponse>(SfResultCodeEnum.SF_IO_ERROR);
        }
        catch (Exception e) {
            LogUtil.error(log, "\u987a\u4e30\u63a5\u53e3 >> \u5f02\u5e38 >> error >> param :{}", request);
            return new SfResponse<SfResponse>(SfResultCodeEnum.SF_ERROR);
        }
        SfResponse<SfResponse> sfResponse = null;
        try {
            sfResponse = (SfResponse<SfResponse>)JSON.parseObject((String)response, SfResponse.class);
        }
        catch (Exception e) {
            LogUtil.error(log, "\u987a\u4e30\u63a5\u53e3 >> \u5e8f\u5217\u5316\u5f02\u5e38 >> param :{}", request);
            return new SfResponse<SfResponse>(SfResultCodeEnum.SF_SERIAL_ERROR);
        }
        if (Misc.isNull(sfResponse)) {
            sfResponse = new SfResponse<SfResponse>(SfResultCodeEnum.RESULT_IS_NULL);
            return sfResponse;
        }
        return sfResponse;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getDevid() {
        return this.devid;
    }

    public String getDevKey() {
        return this.devKey;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setDevid(String devid) {
        this.devid = devid;
    }

    public void setDevKey(String devKey) {
        this.devKey = devKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultSfClient)) {
            return false;
        }
        DefaultSfClient other = (DefaultSfClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$devid = this.getDevid();
        String other$devid = other.getDevid();
        if (this$devid == null ? other$devid != null : !this$devid.equals(other$devid)) {
            return false;
        }
        String this$devKey = this.getDevKey();
        String other$devKey = other.getDevKey();
        return !(this$devKey == null ? other$devKey != null : !this$devKey.equals(other$devKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultSfClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $devid = this.getDevid();
        result = result * 59 + ($devid == null ? 43 : $devid.hashCode());
        String $devKey = this.getDevKey();
        result = result * 59 + ($devKey == null ? 43 : $devKey.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultSfClient(serverUrl=" + this.getServerUrl() + ", devid=" + this.getDevid() + ", devKey=" + this.getDevKey() + ")";
    }
}

