/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfResponse;
import lombok.Data;

/**
 * @author jinbo
 * @version RiderLatestPositionResponse.java, v 0.1 2022-01-11 11:40 上午 jinbo
 */
@Data
public class RiderLatestPositionResponse extends SfResponse<SfResponse> {
    private static final long serialVersionUID = 7043477707531610801L;

    @JSONField(name = "sf_order_id")
    private String sfOrderId;

    @JSONField(name = "shop_order_id")
    private String shopOrderId;

    /**
     * 骑士名称
     */
    @JSONField(name = "rider_name")
    private String riderName;

    /**
     * 骑士电话
     */
    @JSONField(name = "rider_phone")
    private String riderPhone;

    /**
     * 配送员经度
     */
    @JSONField(name = "rider_lng")
    private String riderLng;

    /**
     * 配送员纬度
     */
    @JSONField(name = "rider_lat")
    private String riderLat;

    /**
     * 坐标上传时间（秒级时间戳）
     */
    @JSONField(name = "upload_time")
    private String upload_time;
}