/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfResponse;
import lombok.Data;

import java.util.List;

/**
 * @author jinbo
 * @version PreCreateOrderResponse.java, v 0.1 2022-01-07 4:09 下午 jinbo
 */
@Data
public class PreCreateOrderResponse extends SfResponse<SfResponse> {
    private static final long serialVersionUID = -6787317025502289369L;
    /**
     * 0：预约送达单 1：立即单 3：预约上门单
     */
    @JSONField(name = "delivery_type")
    private Integer deliveryType;

    /**
     * 预计送达（上门）时间
     */
    @JSONField(name = "expect_time")
    private Long expectTime;

    /**
     * 预计开始配送的时间
     */
    @JSONField(name = "start_time")
    private Long startTime;

    /**
     * 预计配送时间（单位: 分）
     */
    @JSONField(name = "promise_delivery_time")
    private Integer promiseDeliveryTime;

    /**
     * 订单小费
     */
    @JSONField(name = "gratuity_fee")
    private Integer gratuityFee;

    @JSONField(name = "push_time")
    private Integer pushTime;

    //以下字段受请求参数中 return_flag 控制：return_flag中未包含的，此字段将不存在，请注意！
    /**
     * 配送费总额，当return_flag中包含1时返回，单位分（值为计算出来此单总价）
     */
    @JSONField(name = "total_price")
    private Integer totalPrice;

    /**
     * 配送距离，当return_flag中包含2时返回，单位米（值为计算出来实际配送距离）
     */
    @JSONField(name = "delivery_distance_meter")
    private Integer deliveryDistanceMeter;

    /**
     * 商品重量，当return_flag中包含4时返回，单位克（值为下单传入参数回传）
     */
    @JSONField(name = "weight_gram")
    private Integer weightPram;

    /**
     * 支付费用，当return_flag中包含32时返回，单位分
     */
    @JSONField(name = "total_pay_money")
    private Integer totalPayMoney;

    /**
     * 实际支付金额，当return_flag中包含64时返回，单位分（实际支付金额=总金额-优惠卷总金额）
     */
    @JSONField(name = "real_pay_money")
    private Integer realPayMoney;

    /**
     * 爆单费，单位分
     */
    @JSONField(name = "overflow_fee")
    private Integer overflowFee;

    /**
     * 结算方式，当return_flag中包含256时返回
     */
    @JSONField(name = "settlement_type")
    private Integer settlementType;

    @JSONField(name = "charge_price_list")
    private List<ChangeResponse> chargePriceList;

    @lombok.Data
    public class ChangeResponse {
        /**
         * 配送费总额（单位:分）
         */
        @JSONField(name = "shop_pay_price")
        private Integer shopPayPrice;

        @JSONField(name = "charges_detail")
        private ChargesDetail chargesDetail;

        @lombok.Data
        public class ChargesDetail {

            @JSONField(name = "basic_fee")
            private Integer basicFee;

            @JSONField(name = "basic")
            private Integer basic;

            @JSONField(name = "over_distance")
            private Integer over_distance;

            @JSONField(name = "over_weight")
            private Integer overWeight;

            @JSONField(name = "cancel_excess_fee")
            private Integer cancelExcessFee;

            @JSONField(name = "special_time_fee")
            private Integer specialTimeFee;

            @JSONField(name = "vas_fee")
            private Integer vasFee;

            @JSONField(name = "vas_fee_detail")
            private VasFeeDetail vasFeeDetail;

            @JSONField(name = "extra_fee")
            private Integer extraFee;

            @JSONField(name = "extra_fee_detail")
            private ExtraFeeDetail extraFeeDetail;

            @lombok.Data
            public class VasFeeDetail {
                @JSONField(name = "packing_fee")
                private Integer packingFee;

                @JSONField(name = "lowTempFee")
                private Integer lowTempFee;

                @JSONField(name = "take_goods_sms_fee")
                private Integer takeGoodsSmsFee;

                @JSONField(name = "insured")
                private Insured insured;

                @JSONField(name = "big_order")
                private BigOrder bigOrder;

                @JSONField(name = "collection")
                private Collection collection;

                @JSONField(name = "person_direct_fee")
                private Integer personDirectFee;

                @JSONField(name = "vehicle_car_fee")
                private Integer vehicleCarFee;

                @lombok.Data
                public class Collection {
                    @JSONField(name = "fee")
                    private Integer fee;

                    @JSONField(name = "price")
                    private Integer price;
                }


                @lombok.Data
                public class BigOrder {
                    @JSONField(name = "fee")
                    private Integer fee;

                    @JSONField(name = "amount")
                    private Integer amount;
                }


                @lombok.Data
                public class Insured {
                    @JSONField(name = "fee")
                    private Integer fee;

                    @JSONField(name = "declared_price")
                    private Integer declaredPrice;
                }

            }

            @lombok.Data
            public class ExtraFeeDetail {

                @JSONField(name = "geography_fee")
                private Integer geographyFee;

            }

        }

    }
}