/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfResponse;
import lombok.Data;

import java.util.List;

/**
 * @author jinbo
 * @version PreCancelResponse.java, v 0.1 2022-01-10 4:01 下午 jinbo
 */
@Data
public class PreCancelOrderResponse extends SfResponse<SfResponse> {
    private static final long serialVersionUID = -5965907384319604180L;

    /**
     * 订单类型，1、顺丰订单号 2、商家订单号
     */
    @JSONField(name = "order_type")
    private Integer orderType;

    /**
     * 承诺配送时长(分)
     */
    @JSONField(name = "promise_delivery_time")
    private Integer promiseDeliveryTime;

    /**
     * 订单类型 0：预约送达单，1：立即单，2：预约上门单
     */
    @JSONField(name = "delivery_type")
    private Integer deliveryType;

    /**
     * 原始期望上门时间
     */
    @JSONField(name = "expect_pickup_time")
    private Integer expectPickupTime;

    /**
     * 预约时间
     */
    @JSONField(name = "expect_time")
    private Integer expectTime;

    /**
     * 店铺每日取消次数
     */
    @JSONField(name = "shop_cancel_times")
    private Integer shopCancelTimes;

    /**
     * 每日免费取消次数
     */
    @JSONField(name = "free_cancel_times")
    private Integer freeCancelTimes;

    /**
     * 取消收费规则
     */
    @JSONField(name = "is_cancel_charge_price_rule")
    private Integer isCancelChargePriceRule;

    /**
     * 是否超出免费取消次数
     */
    @JSONField(name = "is_over_free_cancel_times")
    private Integer isOverFreeCancelTimes;

    /**
     * 是否有取消收费
     */
    @JSONField(name = "is_deduction_fee")
    private Integer isDeductionFee;

    /**
     * 取消收费
     */
    @JSONField(name = "deduction_fee")
    private Integer deductionFee;

    /**
     * 取消收费规则
     */
    @JSONField(name = "cancel_charge_price_rule")
    private List<Object> cancelChargePriceRule;

    /**
     * 能否取消
     */
    @JSONField(name = "could_cancel")
    private Boolean couldCancel;

    /**
     * 推单时间
     */
    @JSONField(name = "push_time")
    private Integer pushTime;

    /**
     * 顺丰订单号
     */
    @JSONField(name = "sf_order_id")
    private String sfOrderId;

    /**
     * 商家订单号
     */
    @JSONField(name = "shop_order_id")
    private String shopOrderId;

}