/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfResponse;
import lombok.Data;

import java.util.List;


/**
 * @author jinbo
 * @version ListOrderFeeResponse.java, v 0.1 2022-01-11 9:20 上午 jinbo
 */
@Data
public class ListOrderFeedResponse extends SfResponse<SfResponse> {
    private static final long serialVersionUID = 3763031297382244666L;

    /**
     * 顺丰订单id
     */
    @JSONField(name = "sf_order_id")
    private String sfOrderId;

    /**
     * 店铺订单id
     */
    @JSONField(name = "shop_order_id")
    private String shopOrderId;

    @JSONField(name = "feed")
    private List<Feed> feed;

    @lombok.Data
    public class Feed{
        /**
         * 顺丰订单id
         */
        @JSONField(name = "sf_order_id")
        private String sfOrderId;

        /**
         * 店铺订单id
         */
        @JSONField(name = "shop_order_id")
        private String shopOrderId;

        /**
         * 订单状态
         */
        @JSONField(name = "order_status")
        private Integer orderStatus;

        @JSONField(name = "operator")
        private String operator;

        @JSONField(name = "operator_name")
        private String operatorName;

        @JSONField(name = "operator_phone")
        private String operatorPhone;

        @JSONField(name = "status_desc")
        private String statusDesc;

        @JSONField(name = "content")
        private String content;

        @JSONField(name = "create_time")
        private String createTime;

    }


}