/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfResponse;
import lombok.Data;

/**
 * @author jinbo
 * @version GetOrderStatusResponse.java, v 0.1 2022-01-11 10:01 上午 jinbo
 */
@Data
public class GetOrderStatusResponse extends SfResponse<SfResponse> {
    private static final long serialVersionUID = 8654502618332839209L;

    /**
     * 顺丰订单id
     */
    @JSONField(name = "order_id")
    private String orderId;

    /**
     * 店铺订单id
     */
    @JSONField(name = "shop_order_id")
    private String shopId;

    /**
     * 店铺订单id
     */
    @JSONField(name = "out_order_id")
    private String outOrderId;

    /**
     * 订单状态
     */
    @JSONField(name = "order_status")
    private Integer orderStatus;

    /**
     * 当前状态
     */
    @JSONField(name = "status_desc")
    private String statusDesc;

    /**
     * 骑士名称
     */
    @JSONField(name = "rider_name")
    private String riderName;

    /**
     * 骑士电话
     */
    @JSONField(name = "rider_phone")
    private String riderPhone;

    /**
     * 订单推送生成的时间
     */
    @JSONField(name = "create_time")
    private String createTime;
}