/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfResponse;
import lombok.Data;

import java.util.List;

/**
 * @author jinbo
 * @version GetOrderGratuityFeeResponse.java, v 0.1 2022-01-11 10:44 上午 jinbo
 */
@Data
public class GetOrderGratuityFeeResponse extends SfResponse<SfResponse> {
    private static final long serialVersionUID = -6728419177627780245L;

    @JSONField(name = "sf_order_id")
    private String sfOrderId;

    @JSONField(name = "shop_order_id")
    private String shopOrderId;

    @JSONField(name = "total_gratuity_fee")
    private Integer totalGratuityFee;

    @JSONField(name = "total_gratuity_times")
    private Integer totalGratuityTimes;

    @JSONField(name = "gratuity_fee_list")
    private List<GratuityFee> gratuityFeeList;

    @lombok.Data
    public class GratuityFee{
        @JSONField(name = "gratuity_fee")
        private Integer gratuityFee;

        @JSONField(name = "gratuity_time")
        private Integer gratuityTime;

    }
}