/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfResponse;
import lombok.Data;

/**
 * @author zhanyiming
 * @version CreateOrderResponse.java, v 0.1 2021-12-09 15:04 zhanyiming
 */
@Data
public class CreateOrderResponse extends SfResponse<SfResponse> {

    private static final long serialVersionUID = -1114348254552780583L;

    @JSONField(name = "sf_order_id")
    private String sfOrderId;

    @JSONField(name = "sf_bill_id")
    private String sfBillId;

    @JSONField(name = "shop_order_id")
    private String shopOrderId;

    @JSONField(name = "push_time")
    private Integer pushTime;

    @JSONField(name = "total_price")
    private Integer totalPrice;

    @JSONField(name = "delivery_distance_meter")
    private Integer deliveryDistanceMeter;

    @JSONField(name = "weight_gram")
    private Integer weightGram;

    @JSONField(name = "start_time")
    private Long startTime;

    @JSONField(name = "expect_time")
    private Long expectTime;

    @JSONField(name = "total_pay_money")
    private Integer totalPayMoney;

    @JSONField(name = "real_pay_money")
    private Integer realPayMoney;

    @JSONField(name = "coupons_total_fee")
    private Integer couponsTotalFee;

    @JSONField(name = "settlement_type")
    private Integer settlementType;

    @JSONField(name = "pickup_code")
    private Integer pickupCode;

    @JSONField(name = "complete_code")
    private Integer completeCode;

    @JSONField(name = "overflow_fee")
    private Integer overflowFee;
}