/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.config.SfApiUrlConstant;
import com.fshows.sdk.sf.api.response.PreCreateOrderResponse;
import lombok.Data;

import java.util.List;

/**
 * @author jinbo
 * @version PreCreateOrderRequest.java, v 0.1 2022-01-07 4:08 下午 jinbo
 */
@Data
public class PreCreateOrderRequest extends BaseRequest implements SfRequest<PreCreateOrderResponse> {

    /**
     * 店铺ID
     */
    @JSONField(name = "shop_id")
    private String shopId;

    /**
     * 店铺ID类型; 1：顺丰店铺ID ；2：接入方店铺ID
     */
    @JSONField(name = "shop_type")
    private Integer shopType;

    /**
     * 用户地址经度
     */
    @JSONField(name = "user_lng")
    private String userLng;

    /**
     * 用户地址纬度
     */
    @JSONField(name = "user_lat")
    private String userLat;

    /**
     * 用户详细地址
     */
    @JSONField(name = "user_address")
    private String userAddress;

    /**
     * 发单城市	用来校验是否跨城；请填写城市的中文名称，如北京市、深圳市
     */
    @JSONField(name = "city_name")
    private String cityName;
    /**
     * 物品重量（单位：克）
     */
    @JSONField(name = "weight")
    private Integer weight;

    /**
     * 物品类型	枚举值见枚举定义 ProductTypeEnum.java
     */
    @JSONField(name = "product_type")
    private Integer productType;

    /**
     * 用户订单总金额（单位：分）
     */
    @JSONField(name = "total_price")
    private Integer totalPrice;

    /**
     * 是否是预约单	0：非预约单；1：预约单
     */
    @JSONField(name = "is_appoint")
    private Integer isAppoint;

    /**
     * 预约单的时候传入，1：预约单送达单；2：预约单上门单
     */
    @JSONField(name = "appoint_type")
    private Integer appointType;

    /**
     * 用户期望送达时间	若传入自此段且时间大于配送时效，则按照预约送达单处理，时间小于配送时效按照立即单处理；appoint_type=1时需必传,秒级时间戳
     */
    @JSONField(name = "expect_time")
    private Integer expectTime;

    /**
     * 用户期望上门时间	appoint_type=2时需必传,秒级时间戳
     */
    @JSONField(name = "expect_pickup_time")
    private Integer expectPickupTime;

    /**
     * 坐标类型，1：百度坐标，2：高德坐标
     */
    @JSONField(name = "lbs_type")
    private Integer lbsType;

    /**
     * 用户支付方式：1、已支付 0、货到付款
     */
    @JSONField(name = "pay_type")
    private Integer payType;

    /**
     * 代收金额	单位：分
     */
    @JSONField(name = "receive_user_money")
    private Integer receiveUserMoney;

    /**
     * 是否保价，0：非保价；1：保价
     */
    @JSONField(name = "is_insured")
    private Integer isInsured;

    /**
     * 是否是专人直送订单，0：否；1：是
     */
    @JSONField(name = "is_person_direct")
    private Integer isPersonDirect;

    /**
     * 配送交通工具，0：否；1：电动车；2：小轿车
     */
    @JSONField(name = "vehicle")
    private Integer vehicle;

    /**
     * 保价金额	单位：分
     */
    @JSONField(name = "declared_value")
    private Integer declaredValue;

    /**
     * 订单小费，不传或者传0为不加小费	单位分，加小费最低不能少于100分
     */
    @JSONField(name = "gratuity_fee")
    private Integer gratuity;

    /**
     * 物流流向	1：从门店取件送至用户；
     */
    @JSONField(name = "rider_pick_method")
    private Integer riderPickMethod;

    /**
     * 从用户取件送至门店
     * return_flag	int	1	否	返回字段控制标志位（二进制）	1:商品总价格，2:配送距离，4:物品重量，8:起送时间，16:期望送达时间，32:支付费用，64:实际支持金额，128:优惠卷总金额，256:结算方式
     * 例如全部返回为填入511
     */
    @JSONField(name = "return_flag")
    private Integer refundFlag;

    /**
     * 推单时间	秒级时间戳
     */
    @JSONField(name = "push_time")
    private Integer pushTime;

    /**
     * 发货店铺信息；obj，详见shop结构	平台级开发者需要传入
     */
    @JSONField(name = "shop")
    private ShopRequest shop;

    /**
     * 多点取货信息 详细见multi_pickup_info结构 (多点取货多商品类型有要求具体类型，顺丰文档没同步)
     */
    @JSONField(name = "multi_pickup_info")
    private List<MultiPickupInfoRequest> multiPickupInfo;

    @lombok.Data
    public static class ShopRequest {

        /**
         * 店铺名称
         */
        @JSONField(name = "shop_name")
        private String shopName;

        /**
         * 店铺电话
         */
        @JSONField(name = "shop_phone")
        private String shopPhone;

        /**
         * 店铺地址
         */
        @JSONField(name = "shop_address")
        private String shopAddress;

        /**
         * 店铺经度
         */
        @JSONField(name = "shop_lng")
        private String shopLng;

        /**
         * 店铺纬度
         */
        @JSONField(name = "shop_lat")
        private String shopLat;
    }


    @lombok.Data
    public class MultiPickupInfoRequest {

        /**
         * 取货点地址
         */
        @JSONField(name = "pickup_shop_address")
        private String pickupShopAddress;

        /**
         * 取货点经度
         */
        @JSONField(name = "pickup_lng")
        private String pickupLng;

        /**
         * 取货点纬度
         */
        @JSONField(name = "pickup_lat")
        private String pickupLat;
    }


    @Override
    public String getApiMethodName() {
        return SfApiUrlConstant.PRECREATE_ORDER;
    }

    @Override
    public String getBusinessParam() {
        return JSON.toJSONString(this);
    }

    @Override
    public Class<PreCreateOrderResponse> getResponseClazz() {
        return PreCreateOrderResponse.class;
    }

}