/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.config.SfApiUrlConstant;
import com.fshows.sdk.sf.api.response.ListOrderFeedResponse;
import lombok.Data;

/**
 * @author jinbo
 * @version ListOrderFeedRequest.java, v 0.1 2022-01-11 9:20 上午 jinbo
 */
@Data
public class ListOrderFeedRequest extends BaseRequest implements SfRequest<ListOrderFeedResponse> {

    /**
     * 	api开发者ID
     */
    @JSONField(name = "dev_id")
    private Integer devId;

    /**
     * 	订单ID
     */
    @JSONField(name = "order_id")
    private String orderId;

    /**
     * 查询订单ID类型：1、顺丰订单号 2、商家订单号
     */
    @JSONField(name = "order_type")
    private Integer orderType;

    /**
     * 店铺ID；	order_type=2时必传shop_id与shop_type
     */
    @JSONField(name = "shop_id")
    private String shopId;

    /**
     * 店铺ID类型； 1、顺丰店铺ID 2、接入方店铺ID
     */
    @JSONField(name = "shop_type")
    private Integer shopType;

    /**
     * 推送时间；秒级时间戳
     */
    @JSONField(name = "push_time")
    private Integer pushTime;

    @Override
    public String getApiMethodName() {
        return SfApiUrlConstant.LIST_ORDER_FEED;
    }

    @Override
    public String getBusinessParam() {
        return JSON.toJSONString(this);
    }

    @Override
    public Class<ListOrderFeedResponse> getResponseClazz() {
        return ListOrderFeedResponse.class;
    }
}