/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.config.SfApiUrlConstant;
import com.fshows.sdk.sf.api.response.AddOrderGratuityFeeResponse;
import lombok.Data;

/**
 * @author jinbo
 * @version AddOrderGratuityFeeRequest.java, v 0.1 2022-01-11 10:12 上午 jinbo
 */
@Data
public class AddOrderGratuityFeeRequest extends BaseRequest implements SfRequest<AddOrderGratuityFeeResponse> {

    /**
     * 	订单ID
     */
    @JSONField(name = "order_id")
    private String orderId;

    /**
     * 查询订单ID类型：1、顺丰订单号 2、商家订单号
     */
    @JSONField(name = "order_type")
    private Integer orderType;

    /**
     * 店铺ID
     */
    @JSONField(name = "shop_id")
    private String shopId;

    /**
     * 店铺ID类型; 1：顺丰店铺ID ；2：接入方店铺ID
     */
    @JSONField(name = "shop_type")
    private Integer shopType;

    /**
     * 订单小费，单位分，加小费最低不能少于100分
     */
    @JSONField(name = "gratuity_fee")
    private Integer gratuityFee;

    /**
     * 加小费传入的唯一标识，用来幂等处理
     */
    @JSONField(name = "serial_number")
    private Integer serialNumber;

    /**
     * 推送时间；秒级时间戳
     */
    @JSONField(name = "push_time")
    private Integer pushTime;

    @Override
    public String getApiMethodName() {
        return SfApiUrlConstant.ADD_ORDER_GRATUITY_FEE;
    }

    @Override
    public String getBusinessParam() {
        return JSON.toJSONString(this);
    }

    @Override
    public Class<AddOrderGratuityFeeResponse> getResponseClazz() {
        return AddOrderGratuityFeeResponse.class;
    }
}