/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.enums;

/**
 * @author jinbo
 * @version OrderExceptionCodeEnum.java, v 0.1 2022-01-06 6:00 下午 jinbo
 */
public enum OrderExceptionEnum {

    /**
     *4003:托寄物丢失或损坏
     */
    LOSS_OR_DAMAGE(4003, "托寄物丢失或损坏"),
    /**
     *1001:商家出货慢
     */
    SHIP_SLOW(1001, "商家出货慢"),
    /**
     * 2010:顾客拒绝实名认证
     */
    CONSUMER_REFUSED_IDENTITIES(2010, "顾客拒绝实名认证"),
    /**
     * 3004:实名认证校验失败
     */
    IDENTITIES_CHECK_FAILURE(3004, "实名认证校验失败"),
    /**
     * 1007:更改取货地址
     */
    CHANGE_RECEIVE_ADDRESS(1007, "更改取货地址"),
    /**
     * 2001:顾客电话无法接通
     */
    CONSUMER_PHONE_DOWN(2001, "顾客电话无法接通"),
    /**
     * 2004:更改期望送达时间
     */
    CHANGE_RECEIVE_TIME(2004,"更改期望送达时间"),
    /**
     * 2005:顾客拒收
     */
    CONSUMER_REFUSE_RECEIVE(2005,"顾客拒收"),
    /**
     * 2008:顾客不在家
     */
    CONSUMER_NOT_AT_HOME(2008, "顾客不在家"),
    /**
     * 2009:更改送货地址
     */
    CHANGE_SEND_ADDRESS(2009, "更改送货地址"),
    /**
     * 4001:配送地址错误
     */
    SEND_ADDRESS_WRONG(4001, "配送地址错误"),
    /**
     * 4002:其他
     */
    OTHER(4002, "其他"),

    ;

    private Integer code;
    private String msg;

    OrderExceptionEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * Getter method for property <tt>code</tt>.
     *
     * @return property value of code
     */
    public Integer getCode() {
        return code;
    }

    /**
     * Getter method for property <tt>msg</tt>.
     *
     * @return property msg of msg
     */
    public String getMsg() {
        return msg;
    }
}