/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.fshows.sdk.sf.api.config;

/**
 * 顺丰接口地址
 *
 * @author zhanyiming
 * @version SfApiUrlConstant.java, v 0.1 2021-12-06  zhanyiming
 */
public class SfApiUrlConstant {

    /**
     * 创建订单
     */
    public static final String CREATE_ORDER = "/open/api/external/createorder";

    /**
     * 预创建订单
     */
    public static final String PRECREATE_ORDER = "/open/api/external/precreateorder";

    /**
     * 取消订单
     */
    public static final String CANCEL_ORDER = "/open/api/external/cancelorder";

    /**
     * 预取消订单
     */
    public static final String PRECANCEL_ORDER = "/open/api/external/precancelorder";

    /**
     * 订单加小费
     */
    public static final String ADD_ORDER_GRATUITY_FEE = "/open/api/external/addordergratuityfee";

    /**
     * 获取订单加小费信息
     */
    public static final String GET_ORDER_GRATUITY_FEE = "/open/api/external/getordergratuityfee";

    /**
     * 获取账户余额
     */
    public static final String GET_SHOP_ACCOUNT_BALANCE = "/open/api/external/getshopaccountbalance";

    /**
     * 订单状态流查询
     */
    public static final String LIST_ORDER_FEED = "/open/api/external/listorderfeed";

    /**
     * 订单实时信息查询
     */
    public static final String GET_ORDER_STATUS = "/open/api/external/getorderstatus";

    /**
     * 催单
     */
    public static final String REMINDER_ORDER = "/open/api/external/reminderorder";

    /**
     * 改单
     */
    public static final String CHANGE_ORDER = "/open/api/external/changeorder";

    /**
     * 获取配送员实时坐标接口
     */
    public static final String RIDER_LATEST_POSITION = "/open/api/external/riderlatestposition";

    /**
     * 获取配送员轨迹H5
     */
    public static final String RIDER_VIEW_V2 = "/open/api/external/riderviewv2";

    /**
     * 订单回调详情
     */
    public static final String GET_CALLBACK_INFO = "/open/api/external/getcallbackinfo";

    /**
     * 商家告知餐品制作完成接口
     */
    public static final String NOTIFY_PRODUCT_READY = "/open/api/external/notifyproductready";
}