/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.fshows.sdk.sf.api;

import com.fshows.sdk.sf.api.exception.SfApiException;

import java.util.List;

/**
 * @author zhanyiming
 * @version SfClient.java, v 0.1 2021-12-07 09:42 zhanyiming
 */
public interface SfClient {

    /**
     * 调用接口
     *
     * @param request
     * @param <T>
     * @return
     * @throws SfApiException
     */
    <T extends SfResponse<SfResponse>> T execute(SfRequest<T> request);

    /**
     * 调用接口返回String
     *
     * @param request
     * @param <T>
     * @return
     * @throws SfApiException
     */
    <T extends SfResponse<SfResponse>> String executeString(SfRequest<T> request);

    /**
     * 调用接口返回Array
     *
     * @param request
     * @param <T>
     * @return
     * @throws SfApiException
     */
    <T extends SfResponse<SfResponse>> List<T> executeArray(SfRequest<T> request);

}